% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel-pivot-table.R
\name{excel_pivot_table}
\alias{excel_pivot_table}
\alias{pivot_table}
\title{Excel Pivot Table}
\usage{
pivot_table(
  .data,
  .rows,
  .columns,
  .values,
  .filters = NULL,
  .sort = NULL,
  fill_na = NA
)
}
\arguments{
\item{.data}{A \code{data.frame} or \code{tibble} that contains data to summarize with a pivot table}

\item{.rows}{Enter one or more groups to assess as expressions (e.g. \code{~ MONTH(date_column)})}

\item{.columns}{Enter one or more groups to assess expressions (e.g. \code{~ YEAR(date_column)})}

\item{.values}{Numeric only. Enter one or more summarization expression(s) (e.g. \code{~ SUM(value_column)})}

\item{.filters}{This argument is not yet in use}

\item{.sort}{This argument is not yet in use}

\item{fill_na}{A value to replace missing values with. Default is \code{NA}}
}
\value{
Returns a tibble that has been pivoted to summarize information by column and row groupings
}
\description{
\strong{The Pivot Table} is one of Excel's most powerful features, and now it's available in \code{R}!
A pivot table is a table of statistics that summarizes the data of a more extensive table
(such as from a database, spreadsheet, or business intelligence program).

These functions are designed to help users coming from an \strong{Excel background}.
Most functions replicate the behavior of Excel:
\itemize{
\item Names are similar to Excel function names
\item Functionality replicates Excel
}
}
\details{
This summary might include sums, averages, or other statistics, which the pivot table groups together in a meaningful way.

The key parameters are:
\itemize{
\item \code{.rows} - These are groups that will appear as row-wise headings for the summarization, You can modify these groups by applying collapsing functions (e.g. (\code{YEAR()}).
\item \code{.columns} - These are groups that will appear as column headings for the summarization. You can modify these groups by applying collapsing functions (e.g. (\code{YEAR()}).
\item \code{.values} - These are numeric data that are summarized using a summary function
(e.g. \code{SUM()}, \code{AVERAGE()}, \code{COUNT()}, \code{FIRST()}, \code{LAST()}, \code{SUM_IFS()}, \code{AVERAGE_IFS()}, \code{COUNT_IFS()})
}

\strong{R implementation details.}
\itemize{
\item The \code{pivot_table()} function is powered by the \code{tidyverse}, an ecosystem of packages designed to manipulate data.
\item All of the key parameters can be expressed using a functional form:
\itemize{
\item Rows and Column Groupings can be collapsed. Example: \code{.columns = ~ YEAR(order_date)}
\item Values can be summarized provided a single value is returned. Example: \code{.values = ~ SUM_IFS(order_volume >= quantile(order_volume, probs = 0.75))}
\item Summarizations and Row/Column Groupings can be stacked (combined) with \code{c()}. Example: \code{.rows = c(~ YEAR(order_date), company)}
\item Bare columns (e.g. \code{company}) don not need to be prefixed with the \code{~}.
\item \strong{All grouping and summarizing functions MUST BE prefixed with \code{~}}. Example: \code{.rows = ~ YEAR(order_date)}
}
}
}
\examples{
# PIVOT TABLE ----
# Calculate returns by year/quarter
FANG \%>\%
    pivot_table(
        .rows       = c(symbol, ~ QUARTER(date)),
        .columns    = ~ YEAR(date),
        .values     = ~ PCT_CHANGE_FIRSTLAST(adjusted)
    )

}
