% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windows_stats_generic.R
\name{windows_stats_generic}
\alias{windows_stats_generic}
\title{Estimate window statistics from per locus estimates}
\usage{
windows_stats_generic(
  .x,
  loci_table,
  operator = c("mean", "sum", "custom"),
  window_size,
  step_size,
  size_unit = c("snp", "bp"),
  min_loci = 1,
  complete = FALSE,
  f = NULL,
  ...
)
}
\arguments{
\item{.x}{A vector containing the per locus estimates.}

\item{loci_table}{a dataframe including at least a column 'chromosome', and
additionally a column 'position' if \code{size_unit} is "bp".}

\item{operator}{The operator to use for the window statistics. Either "mean",
"sum" or "custom" to use a custom function \code{.f}.}

\item{window_size}{The size of the window to use for the estimates.}

\item{step_size}{The step size to use for the windows.}

\item{size_unit}{Either "snp" or "bp". If "snp", the window size and step
size are in number of SNPs. If "bp", the window size and step size are in
base pairs.}

\item{min_loci}{The minimum number of loci required to calculate a window
statistic. If the number of loci in a window is less than this, the window
statistic will be NA.}

\item{complete}{Should the function be evaluated on complete windows only? If
FALSE, the default, then partial computations will be allowed at the end of
the chromosome.}

\item{f}{a custom function to use for the window statistics. This function
should take a vector of locus estimates and return a single value.}

\item{...}{Additional arguments to be passed to the custom operator function.}
}
\value{
A tibble with columns: 'chromosome', 'start', 'end', 'stats', and
'n_loci'. The 'stats' column contains the mean of the per locus estimates
in the window, and 'n_loci' contains the number of loci in the window.
}
\description{
This function is mostly designed for developers: it is a general function to
estimate window statistics from per locus estimates. This function takes a
vector of per locus estimates, and aggregates them by sum or mean per window.
To compute specific quantities directly from a \code{gen_tibble}, use the
appropriate \verb{window_*} functions, e.g \code{\link[=windows_pairwise_pop_fst]{windows_pairwise_pop_fst()}} to compute
pairwise Fst.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

miss_by_locus <- loci_missingness(example_gt)

# Calculate mean missingness across windows
windows_stats_generic(miss_by_locus,
  loci_table = show_loci(example_gt),
  operator = "mean", window_size = 1000,
  step_size = 1000, size_unit = "bp",
  min_loci = 1, complete = FALSE
)

}
