% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tx_vl_unsuppressed.R
\name{tx_vl_unsuppressed}
\alias{tx_vl_unsuppressed}
\title{Determine Clients who are not Virally Suppressed}
\usage{
tx_vl_unsuppressed(
  data,
  ref = NULL,
  states = NULL,
  facilities = NULL,
  status = "calculated",
  n = 1000
)
}
\arguments{
\item{data}{An NDR dataframe imported using the `read_ndr().}

\item{ref}{Date provided in ISO8601 format ("yyyy-mm-dd"). Used to
determine clients who are eligible for viral load and should have a
documented result. The default is the date of analysis.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}

\item{status}{Determines how the number of active clients is calculated.
The options are to either to use the NDR current_status_28_days column
or the derived current_status column ("calculated").}

\item{n}{the value below which viral load result is adjudged to be suppressed.}
}
\value{
tx_vl_unsuppressed
}
\description{
Generate the line-list of clients whose date of last viral load result is not
not more than one year (for adults 20 years and above) and 6 months (for
pediatrics and adolescents) from the specified reference date and are not virally
suppressed.
}
\examples{
tx_vl_unsuppressed(ndr_example)

# Determine clients who are virally unsuppressed for a state at the end of Q1
tx_vl_unsuppressed(ndr_example,
  ref = "2021-12-31",
  states = "Ayetoro"
)

# Determine clients with viral load result of 400 or more (low level viremia)
tx_vl_unsuppressed(ndr_example, n = 400)
}
