% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_complexity.R
\name{json_complexity}
\alias{json_complexity}
\title{Compute the complexity (recursively unlisted length) of JSON data}
\usage{
json_complexity(.x, column.name = "complexity")
}
\arguments{
\item{.x}{a json string or tbl_json object}

\item{column.name}{the name to specify for the length column}
}
\value{
a \code{\link{tbl_json}} object
}
\description{
When investigating complex JSON data it can be helpful to identify the
complexity of deeply nested documents. The \code{json_complexity} function
adds a column (default name \code{"complexity"}) that contains the
'complexity' of the JSON associated with each row. Essentially, every on-null
scalar value is found in the object by recursively stripping away all objects
or arrays, and the complexity is the count of these scalar values. Note that
'null' has complexity 0, as do empty objects and arrays.
}
\examples{

# A simple example
json <- c('[1, 2, [3, 4]]', '{"k1": 1, "k2": [2, [3, 4]]}', '1', 'null')

# Complexity is larger than length for nested objects
json \%>\% json_lengths \%>\% json_complexity

# Worldbank has complexity ranging from 8 to 17
library(magrittr)
worldbank \%>\% json_complexity \%$\% table(complexity)

# Commits are much more regular
commits \%>\% gather_array \%>\% json_complexity \%$\% table(complexity)
}
\seealso{
\code{\link{json_lengths}} to compute the length of each value
}
