% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhs.R
\name{fhs}
\alias{fhs}
\title{Freehand select}
\usage{
fhs(data, mark = TRUE, names = TRUE, ...)
}
\arguments{
\item{data}{Data frame or matrix of co-ordinates. (x,y) co-ordinates for each
point will be on rows. Rownames of selected points will be returned.}

\item{mark}{Default TRUE. Predicate marking of selected points.}

\item{names}{Default TRUE. If TRUE will return rownames of data frame with
points within polygon. If FALSE will return logical vector.}

\item{...}{Additional parameters passed to \code{\link{points}}.}
}
\value{
Returns character vector of rownames of the selected points from \code{data} if
names parameter is TRUE. If names is FALSE then a logical vector indicating whether points
are in the polygon is returned.
}
\description{
Freehand select
}
\details{
Freehand select function. First generate a 2D plot using R's plot function, 
then select gate region by left clicking. Close polygon by right clicking.
The function will return the rownames of the enclosed points by the rownames
of th co-ordinates given in \code{data}.
}
\examples{
\dontrun{
x <- cbind(1:10, 1:10)
rownames(x) <- 1:10
plot(x, pch = 16, col = "red")
fhs(x)
}
}
\author{
Wajid Jawaid
}
