% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.R
\name{in_dt}
\alias{in_dt}
\alias{as_dt}
\title{Short cut to data.table}
\usage{
in_dt(.data, ...)

as_dt(.data)
}
\arguments{
\item{.data}{A data.frame}

\item{...}{Recieve \code{B} in data.table's \code{A[B]} syntax.}
}
\description{
To use facilities provided by \pkg{data.table}, but do not have to
load \pkg{data.table} package.
}
\details{
The \code{as_dt} could turn any data frame to data.table class. If the data is
not a data frame, return error.

The \code{in_dt} function creates a virtual environment in data.table, it could be
piped well because it still follows the principals of \pkg{tidyfst}, which are: (1) Never
use in place replacement and (2) Always recieves a data frame (data.frame/tibble/data.table)
and returns a data.table. Therefore, the in place functions like \code{:=} will still
return the results.
}
\examples{
iris \%>\% as_dt()
iris \%>\% in_dt(order(-Sepal.Length),.SD[.N],by=Species)
}
\seealso{
\code{\link[data.table]{data.table}}
}
