% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.tidyfit.models.R
\name{coef.tidyfit.models}
\alias{coef.tidyfit.models}
\title{Extract coefficients from a \code{tidyfit.models} frame}
\usage{
\method{coef}{tidyfit.models}(
  object,
  ...,
  .add_bootstrap_interval = FALSE,
  .bootstrap_alpha = 0.05,
  .keep_grid_id = FALSE
)
}
\arguments{
\item{object}{\code{model.frame} created using \code{\link{regress}}, \code{\link{classify}} or \code{\link{m}}}

\item{...}{currently not used}

\item{.add_bootstrap_interval}{calculate bootstrap intervals for the parameters. See 'Details'.}

\item{.bootstrap_alpha}{confidence level used for the bootstrap interval. Default is \code{.bootstrap_alpha = 0.05}.}

\item{.keep_grid_id}{boolean. By default the grid ID column is dropped, if there is only one unique setting per model or group. \code{.keep_grid_id = TRUE} ensures that the column is never dropped.}
}
\value{
A 'tibble'.
}
\description{
The function extracts and prepares coefficients from all models in a \code{tidyfit.models} frame and outputs a tidy frame of estimates.
}
\details{
The function uses the 'model_object' column in a \code{tidyfit.model} frame to return a data frame of estimated coefficients.

Results are 'tidied' using \code{broom::tidy} whenever possible.

All coefficients are transformed to ensure statistical comparability. For instance, standardized coefficients are always transformed back to the original data scale, naming conventions are harmonized etc.
\subsection{Bootstrap intervals}{

Bootstrap intervals can be calculated using \code{rsample::int_pctl}. Only set \code{.add_bootstrap_interval = TRUE} if you are using \code{.cv = "bootstraps"} in combination with \code{.return_slices = TRUE} to generate the model frame.
}
}
\examples{
data <- tidyfit::Factor_Industry_Returns
fit <- regress(data, Return ~ ., m("lm"), .mask = c("Date", "Industry"))
coef(fit)

}
\seealso{
\code{\link{predict.tidyfit.models}}, \code{\link{fitted.tidyfit.models}} and \code{\link{residuals.tidyfit.models}}
}
\author{
Johann Pfitzinger
}
