% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-graph.R
\name{get_edges}
\alias{get_edges}
\title{Get edges in a CWL workflow into a data frame}
\usage{
get_edges(outputs, steps)
}
\arguments{
\item{outputs}{Parsed outputs}

\item{steps}{Parsed steps}
}
\value{
Data frame containing edge information
}
\description{
Get edges in a CWL workflow into a data frame
}
\examples{
# edges represented by a dictionary
flow <- system.file("cwl/sbg/workflow/rnaseq-salmon.json", package = "tidycwl") \%>\% read_cwl_json()
get_edges(
  flow \%>\% parse_outputs(),
  flow \%>\% parse_steps()
) \%>\% str()

# edges represented by a list
flow <- system.file("cwl/sbg/workflow/rnaseq-salmon.cwl", package = "tidycwl") \%>\% read_cwl_yaml()
get_edges(
  flow \%>\% parse_outputs(),
  flow \%>\% parse_steps()
) \%>\% str()
}
