% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-mac.R
\docType{data}
\name{curry_mac}
\alias{curry_mac}
\title{Simulated MAC data}
\format{
A data.frame with 1392 rows and 42 variables.
}
\usage{
data(curry_mac)
}
\description{
This simulated dataset, based on Curry et al., 2019, contains data on moral
relevance and judgment across the seven domains of the Morality As
Cooperation scale.
}
\details{
\tabular{lll}{
  \strong{sex} \tab \code{factor} \tab Self-identified sex of participants, Male, Female, or Transgendered.\cr
  \strong{age_years} \tab \code{numeric} \tab Participants' age in years.\cr
  \strong{KinshipR} \tab \code{numeric} \tab Mean score of moral relevance, kinship subscale.\cr
  \strong{MutualismR} \tab \code{numeric} \tab Mean score of moral relevance, mutualism subscale.\cr
  \strong{ExchangeR} \tab \code{numeric} \tab Mean score of moral relevance, exchange subscale.\cr
  \strong{HawkR} \tab \code{numeric} \tab Mean score of moral relevance, hawk subscale.\cr
  \strong{DoveR} \tab \code{numeric} \tab Mean score of moral relevance, dove subscale.\cr
  \strong{DivisionR} \tab \code{numeric} \tab Mean score of moral relevance, division subscale.\cr
  \strong{PossessionR} \tab \code{numeric} \tab Mean score of moral relevance, possession subscale.\cr
  \strong{KinshipJ} \tab \code{numeric} \tab Mean score of moral judgment, kinship subscale.\cr
  \strong{MutualismJ} \tab \code{numeric} \tab Mean score of moral judgment, mutualism subscale.\cr
  \strong{ExchangeJ} \tab \code{numeric} \tab Mean score of moral judgment, exchange subscale.\cr
  \strong{HawkJ} \tab \code{numeric} \tab Mean score of moral judgment, hawk subscale.\cr
  \strong{DoveJ} \tab \code{numeric} \tab Mean score of moral judgment, dove subscale.\cr
  \strong{DivisionJ} \tab \code{numeric} \tab Mean score of moral judgment, division subscale.\cr
  \strong{PossessionJ} \tab \code{numeric} \tab Mean score of moral judgment, possession subscale.
}
}
\references{
Curry, O. S., Jones Chesters, M., & Van Lissa, C. J. (2019). Mapping morality with a compass: Testing the theory of ‘morality-as-cooperation’ with a new questionnaire. Journal of Research in Personality, 78, 106–124.
\doi{10.1016/j.jrp.2018.10.008}
}
\keyword{datasets}
