% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-profiles-mplus.R
\name{estimate_profiles_mplus2}
\alias{estimate_profiles_mplus2}
\title{Estimate latent profiles using Mplus}
\usage{
estimate_profiles_mplus2(df, n_profiles, model_numbers, select_vars, ...,
  keepfiles = FALSE)
}
\arguments{
\item{df}{data.frame with two or more columns with continuous variables}

\item{n_profiles}{Numeric vector. The number of profiles (or mixture
components) to be estimated. Each number in the vector corresponds to an
analysis with that many mixture components.}

\item{model_numbers}{Numeric vector. Numbers of the models to be estimated.
See \code{\link{estimate_profiles}} for a description of the models available
in tidyLPA.}

\item{select_vars}{Character. Optional vector of variable names in \code{df},
to be used for model estimation. Defaults to \code{NULL}, which means all
variables in \code{df} are used.}

\item{...}{Parameters passed directly to
\code{\link[MplusAutomation]{mplusModeler}}. See the documentation of
\code{\link[MplusAutomation]{mplusModeler}}.}

\item{keepfiles}{Logical. Whether to retain the files created by
\code{mplusModeler} (e.g., for future reference, or to manually edit them).}
}
\value{
An object of class 'tidyLPA' and 'list'
}
\description{
Estimates latent profiles (finite mixture models) using the commercial
program Mplus, through the R-interface of
\code{\link[MplusAutomation:mplusModeler]{MplusAutomation}}.
}
\author{
Caspar J. van Lissa
}
