% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\name{expand_index}
\alias{expand_index}
\title{Expand a \code{tbl_time} index}
\usage{
expand_index(x, period)
}
\arguments{
\item{x}{A \code{tbl_time} object}

\item{period}{The most granular period to expand to}
}
\description{
Retrieve an expanded version of a \code{tbl_time} index.
}
\details{
The expanded version of the index only expands as far as necessary
to generate a unique row for the period selected
}
\examples{

x <- tibble::tibble(
  date  = as.Date(c('2017-01-01', '2017-01-02')),
  value = c(1, 2)
)

x <- as_tbl_time(x, date)

expand_index(x, "monthly")

}
