% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sounding_save.R
\name{sounding_save}
\alias{sounding_save}
\title{Save `sounding_layout` to a graphical file}
\usage{
sounding_save(
  pressure,
  altitude,
  temp,
  dpt,
  wd,
  ws,
  title = "",
  parcel = "MU",
  filename,
  ...
)
}
\arguments{
\item{pressure}{pressure [hPa]}

\item{altitude}{altitude [m] (can be above sea level or above ground level as function always consider first level as a surface, i.e h = 0 m)}

\item{temp}{temperature [degree Celsius]}

\item{dpt}{dew point temperature [degree Celsius]}

\item{wd}{wind direction in degrees [azimuth in degrees]}

\item{ws}{wind speed [knots]}

\item{title}{title to be added in the layout's header}

\item{parcel}{parcel tracing on Skew-T for "MU", "ML" or "SB" parcel}

\item{filename}{output file name with extension indicating file format (e.g. "my_plot.png" or "my_plot.svg")}

\item{...}{other arguments that can be used with `sounding_plot` or other graphic arguments}
}
\value{
graphical file with Skew-T and hodograph layout
}
\description{
Auxiliary function to `sounding_plot` that plots a composite \
of Skew-T, hodograph and selected convective parameters \
on a single layout and saves as graphical file.
}
\examples{
\donttest{
data("sounding_vienna")
attach(sounding_vienna)
sounding_save(filename = "Vienna.png", 
              pressure, altitude, temp, dpt, wd, ws, parcel = "MU", 
              title = "Vienna - 23 August 2011, 12:00 UTC")
} 

}
