% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/scatterplot.R
\name{scatterplot3js}
\alias{scatterplot3js}
\title{scatterplot3js Three.js 3D scatterplot widget.}
\usage{
scatterplot3js(x, y, z, height = NULL, width = NULL, axis = TRUE,
  num.ticks = c(6, 6, 6), x.ticklabs = NULL, y.ticklabs = NULL,
  z.ticklabs = NULL, color = "steelblue", size = 1, labels = NULL,
  label.margin = "10px", stroke = "black", flip.y = TRUE, grid = TRUE,
  renderer = c("auto", "canvas", "webgl"), signif = 8, bg = "#ffffff",
  xlim, ylim, zlim, pch)
}
\arguments{
\item{x}{Either a vector of x-coordinate values or a  three-column
data matrix with columns corresponding to the x,y,z
coordinate axes. Column labels, if present, are used as axis labels.}

\item{y}{(Optional) vector of y-coordinate values, not required if
\code{x} is a matrix.}

\item{z}{(Optional) vector of z-coordinate values, not required if
\code{x} is a matrix.}

\item{height}{The container div height.}

\item{width}{The container div width.}

\item{axis}{A logical value that when \code{TRUE} indicates that the
axes will be displayed.}

\item{num.ticks}{A three-element vector with the suggested number of
ticks to display per axis. Set to NULL to not display ticks. The number
of ticks may be adjusted by the program.}

\item{x.ticklabs}{A vector of tick labels of length \code{num.ticks[1]}, or
\code{NULL} to show numeric labels.}

\item{y.ticklabs}{A vector of tick labels of length \code{num.ticks[2]}, or
\code{NULL} to show numeric labels.}

\item{z.ticklabs}{A vector of tick labels of length \code{num.ticks[3]}, or
\code{NULL} to show numeric labels.}

\item{color}{Either a single hex or named color name (all points same color),
or a vector of #' hex or named color names as long as the number of data
points to plot.}

\item{size}{The plot point radius, either as a single number or a
vector of sizes of length \code{nrow(x)}. A vector of sizes is only
supported by the \code{canvas} renderer. The \code{webgl} renderer accepts
a single size value for all points.}

\item{labels}{Either NULL (no labels), or a vector of labels as long as the
number of data points displayed when the mouse hovers over each point.}

\item{label.margin}{A CSS-style margin string used to display the point
labels.}

\item{stroke}{A single color stroke value (surrounding each point). Set to
null to omit stroke (only available in the canvas renderer).}

\item{flip.y}{Reverse the direction of the y-axis (the default value of
TRUE produces plots similar to those rendered by the R
\code{scatterplot3d} package).}

\item{grid}{Set FALSE to disable display of a grid.}

\item{renderer}{Select from available plot rendering techniques of
'auto', 'canvas', or 'webgl'.}

\item{signif}{Number of significant digits used to represent point
coordinates. Larger numbers increase accuracy but slow plot generation
down.}

\item{bg}{The color to be used for the background of the device region.}

\item{xlim}{Optional two-element vector of x-axis limits. Default auto-scales to data.}

\item{ylim}{Optional two-element vector of y-axis limits. Default auto-scales to data.}

\item{zlim}{Optional two-element vector of z-axis limits. Default auto-scales to data.}

\item{pch}{Not yet used but one day will support changing the point glyph.}
}
\description{
A 3D scatterplot widget using three.js. Many options
follow the \code{scatterplot3d} function from the eponymous package.
}
\note{
Use the \code{renderer} option to manually select from the available
rendering options.
The \code{canvas} renderer is the fallback rendering option when \code{webgl}
is not available. Select \code{auto} to automatically choose between
the two. The two renderers produce slightly different-looking output
and have different available options (see above). Use the \code{webgl}
renderer for plotting large numbers of points (if available). Use the
\code{canvas} renderer to excercise finer control of plotting of smaller
numbers of points. See the examples.
}
\examples{
\dontrun{
# Gumball machine
N <- 100
i <- sample(3, N, replace=TRUE)
x <- matrix(rnorm(N*3),ncol=3)
lab <- c("small", "bigger", "biggest")
scatterplot3js(x, color=rainbow(N), labels=lab[i],
               size=i, renderer="canvas")

# Example 1 from the scatterplot3d package (cf.)
z <- seq(-10, 10, 0.1)
x <- cos(z)
y <- sin(z)
scatterplot3js(x,y,z, color=rainbow(length(z)),
   labels=sprintf("x=\%.2f, y=\%.2f, z=\%.2f", x, y, z))

# Interesting 100,000 point cloud example, should run this with WebGL!
N1 <- 10000
N2 <- 90000
x <- c(rnorm(N1, sd=0.5), rnorm(N2, sd=2))
y <- c(rnorm(N1, sd=0.5), rnorm(N2, sd=2))
z <- c(rnorm(N1, sd=0.5), rpois(N2, lambda=20)-20)
col <- c(rep("#ffff00",N1),rep("#0000ff",N2))
scatterplot3js(x,y,z, color=col, size=0.25)

# A shiny example
shiny::runApp(system.file("examples/scatterplot",package="threejs"))
}
}
\references{
The three.js project \url{http://threejs.org}.
}
\seealso{
scatterplot3d, rgl
}

