% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threejs_brain.R
\name{threejs_brain}
\alias{threejs_brain}
\title{Create a Threejs Brain}
\usage{
threejs_brain(..., widget_id = "threebrain_data", time_range = NULL,
  value_range = NULL, symmetric = 0, side_camera = FALSE,
  control_panel = TRUE, control_presets = NULL, camera_center = c(0,
  0, 0), camera_pos = c(0, 0, 500), start_zoom = 1,
  color_ramp = c("navyblue", "#e2e2e2", "red"),
  color_type = "continuous", n_color = 64,
  color_names = seq_along(color_ramp), show_legend = TRUE,
  legend_title = "Value", tmp_dirname = NULL, width = NULL,
  height = NULL, optionals = list(), debug = FALSE, token = NULL,
  coords = NULL, .list = list())
}
\arguments{
\item{..., .list}{geometries inherit from AbstractGeom}

\item{widget_id}{unique identifier for the widget. Use it when you have
multiple widgets in one website (shiny for example)}

\item{time_range}{used to calculate animation time (not yet implemented)}

\item{value_range}{used to generate colors}

\item{symmetric}{default 0, color center will be mapped to this value}

\item{side_camera}{enable side cameras to view objects from fixed perspective}

\item{control_panel}{enable control panels for the widget}

\item{control_presets}{presets to be shown in control panels}

\item{camera_center}{position where camera should focus at}

\item{camera_pos}{XYZ position of camera}

\item{start_zoom}{numeric, positive number indicating start zoom level}

\item{color_ramp}{used to generate color ramps}

\item{color_type}{'continuous' or 'discrete'}

\item{n_color}{how many colors in the color ramp (used by continuous legend)}

\item{color_names}{color names (used by discrete legend)}

\item{show_legend}{show legend in control panel?}

\item{legend_title}{legend title}

\item{tmp_dirname}{internally used}

\item{width, height}{width and height of the widget. By default width="100%",
and height varies.}

\item{optionals}{internally used}

\item{debug}{internally used for debugging}

\item{token}{used to identify widgets in JS localStorage}

\item{coords}{\code{NULL} to hide coordinates or numeric vector of three.}
}
\description{
Create a Threejs Brain
}
