% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{blendcolors}
\alias{blendcolors}
\title{Blends a list of colors using the specified blend mode}
\usage{
blendcolors(colors, mode = c("blend", "average", "screen", "multiply"))
}
\arguments{
\item{colors}{Color vectors.}

\item{mode}{Blend mode.
One of \code{"blend"}, \code{"average"}, \code{"screen"}, or \code{"multiply"}.}
}
\value{
A character vector of hexadecimal color codes representing the blended color.
}
\description{
Blends a list of colors using the specified blend mode
}
\examples{
blend <- c(
  "red",
  "green",
  blendcolors(c("red", "green"),
    mode = "blend"
  )
)
average <- c(
  "red",
  "green",
  blendcolors(c("red", "green"),
    mode = "average"
  )
)
screen <- c(
  "red",
  "green",
  blendcolors(c("red", "green"),
    mode = "screen"
  )
)
multiply <- c(
  "red",
  "green",
  blendcolors(c("red", "green"),
    mode = "multiply"
  )
)
show_palettes(
  list(
    "blend" = blend,
    "average" = average,
    "screen" = screen,
    "multiply" = multiply
  )
)
}
