\name{this.path}
\alias{this.path}
\alias{this.dir}
\alias{this.path2-deprecated}
\alias{this.dir2-deprecated}
\alias{this.dir3-deprecated}
\title{Determine Executing Script's Filename
}
\description{
\code{this.path()} returns the \code{\link[base:normalizePath]{normalized}}
path of the executing script.

\code{this.dir()} returns the \code{\link[base:normalizePath]{normalized}} path
of the directory in which the executing script is located.

\code{this.path2()}, \code{this.dir2()}, and \code{this.dir3()} are from an old
release that did not include \code{default} as an argument in
\code{this.path()} or \code{this.dir()}. They should not be used in future code
development and should be removed from older code.
}
\usage{
this.path(verbose = getOption("verbose"), default)
this.dir(..., default)

this.path2(...)  # deprecated, use this.path(..., default = NULL) instead
this.dir2(...)   # deprecated, use this.dir(..., default = NULL) instead

this.dir3(...)   # deprecated, use this.dir(..., default = getwd()) instead
}
\arguments{
  \item{verbose}{
\code{TRUE} or \code{FALSE}; should the method in which the path was determined
be printed?
  }
  \item{default}{
if there is no executing script, this value is returned. This facilitates
retrieving the execting script's path / / directory and checking whether it
exists and setting it separately if not.
  }
  \item{\dots}{
arguments passed to \code{this.path}.
  }
}
\details{
There are three ways in which \R code is typically run; in \sQuote{RStudio} or
\sQuote{Rgui} by running the current line or selection with the \strong{Run}
button (or appropriate keyboard shortcut), through a source call (a call to
function \code{\link[base]{source}}, \code{\link[base]{sys.source}},
\href{https://support.rstudio.com/hc/en-us/articles/205612627-Debugging-with-the-RStudio-IDE}{
\code{debugSource}} in \sQuote{RStudio}, or
\code{\link[testthat:source_file]{testthat::source_file}}), and from a shell
(including the Windows command-line / / Unix terminal).

To retrieve the executing script's filename, first an attempt is made to find a
source call. The calls are searched in reverse order so as to grab the most
recent source call in the case of nested source calls. If a source call was
found, the argument \var{file} (\var{fileName} in the case of
\code{debugSource}, \var{path} in the case of \code{testthat::source_file}) is
returned from the function's evaluation environment. If you have your own
source-like function that you'd like to be recognized by \code{this.path},
please contact the package maintainer so that it can be implemented.

If no source call is found up the calling stack, then an attempt is made to
figure out how \R is currently being used.

If \R is being run from a shell, the shell arguments are searched for
\option{-f} \option{FILE} or \option{--file=FILE} (the two methods of taking
input from \option{FILE}). If exactly one of either type of argument is
supplied, the text \option{FILE} is returned. It is an error to use
\code{this.path} when none or multiple arguments of either type are supplied.

If \R is being run from a shell under Unix-alikes with \option{-g} \option{Tk}
or \option{--gui=Tk}, \code{this.path()} will signal an error. This is because
\sQuote{Tk} does not make use of its \option{-f} \option{FILE},
\option{--file=FILE} argument.

If \R is being run from \sQuote{RStudio}, the active document's filename (the
document in which the cursor is active) is returned (at the time of evaluation).
If the active document is the \R console, the source document's filename (the
document open in the current tab) is returned (at the time of evaluation).
Please note that the source document will \emph{NEVER} be a document open in
another window (with the \strong{Show in new window} button). It is important to
not leave the current tab (either by closing or switching tabs) while any calls
to \code{this.path} have yet to be evaluated in the run selection. It is an
error for no documents to be open or for a document to not exist (not saved
anywhere).

If \R is being run from \sQuote{Rgui}, the source document's filename (the
document most recently interacted with besides the \R Console) is returned (at
the time of evaluation). Please note that minimized documents will be
\emph{INCLUDED} when looking for the most recently used document. It is
important to not leave the current document (either by closing the document or
interacting with another document) while any calls to \code{this.path} have yet
to be evaluated in the run selection. It is an error for no documents to be
open or for a document to not exist (not saved anywhere).

If \R is being run from \sQuote{AQUA}, the executing script's path cannot be
determined. Unlike \sQuote{RStudio} and \sQuote{Rgui}, there is currently no
way to request the path of an open document. Until such a time that there is a
method for requesting the path of an open document, consider using
\sQuote{RStudio}.

If \R is being run in another manner, it is an error to use \code{this.path}.

If your GUI of choice is not implemented with \code{this.path}, please contact
the package maintainer so that it can be implemented.
}
\value{
character string; the executing script's filename.
}
% There are a few reasons why there would be no executing script:
% \itemize{
%   \item{
% \R is being run from a shell without supplying argument \option{-f}
% \option{FILE} or \option{--file=FILE}
%   }
%   \item{
% \R is being run from a shell under Unix-alikes with option \option{-g}
% \option{Tk} or \option{--gui=Tk} (GUI \sQuote{Tk} does not make use of its
% \option{-f} \option{FILE} or \option{--file=FILE} arguments)
%   }
%   \item{
% \R is being run from \sQuote{RStudio} with no documents open
%   }
%   \item{
% \R is being run from \sQuote{Rgui} with no documents open
%   }
% }
% The following cases will still throw an error:
% \itemize{
%   \item{
% unable to \code{\link[base:normalizePath]{normalize}} the executing script's
% filename
%   }
%   \item{
% using \code{\link[base]{sys.source}} or
% \code{\link[testthat:source_file]{testthat::source_file}} on a file named
% \dQuote{clipboard}, \dQuote{clipboard-128}, or \dQuote{stdin}
%   }
%   \item{
% active / / source document in \sQuote{RStudio} / / \sQuote{Rgui} does not exist
% (not saved anywhere)
%   }
%   \item{
% in \sQuote{AQUA}, running the current line or selection from an open \R script
% (currently unimplemented)
%   }
% }
\note{
The first time \code{this.path} is called within a script, it will
\code{\link[base:normalizePath]{normalize}} the script's path, check that the
script exists (throwing an error if it does not), and save it in the appropriate
environment. When \code{this.path} is called subsequent times within the same
script, it returns the saved path. This will be faster than the first time, will
not check for file existence, and will be independent of the working directory.

As a side effect, this means that a script can delete itself using
\code{\link[base:files]{file.remove}} or \code{\link[base]{unlink}} but still
know its own path for the remainder of the script.

Within a script that contains calls to both \code{this.path} and
\code{\link[base:getwd]{setwd}}, \code{this.path} \emph{MUST} be used
\emph{AT LEAST} once before the first call to \code{setwd}. This isn't always
necessary; for instance if you ran a script using its absolute path as opposed
to its relative path, changing the working directory has no effect. However, it
is still advised against.

The following is \emph{NOT} an example of bad practice:

\code{setwd(this.path::this.dir())}

\code{setwd} is most certainly written before \code{this.path()}, but
\code{this.path()} will be evaluated first. It is not the written order that is
bad practice, but the order of evaluation. Do not change the working directory
before calling \code{this.path} at least once.
}
\seealso{
\code{\link{here}}

\code{\link{shFILE}}

\code{\link{this.path-package}}

\code{\link[base]{source}}, \code{\link[base]{sys.source}},
\href{https://support.rstudio.com/hc/en-us/articles/205612627-Debugging-with-the-RStudio-IDE}{
\code{debugSource}}, \code{\link[testthat:source_file]{testthat::source_file}}

\code{\link{R.from.shell}}
}
%\examples{
%\dontrun{
%The following will create a temporary R script containing
%calls to 'this.path'. You should see that 'this.path' works
%through a call to 'source', a call to 'sys.source', a call
%to 'debugSource' (if running from 'RStudio'), and when
%running R from a shell.
%
%Unfortunately, it is impossible to use 'example(this.path)'
%to demonstrate the functionality of 'this.path' in 'RStudio'
%and 'Rgui'. If you would like to see this functionality, you
%could try this:
%* make a new R script containing just this one command:
%    this.path::this.path(verbose = TRUE)
%* open this script in 'RStudio' or 'Rgui'
%* run that command directly from the script
%  (both should print "Source: active document ..." along
%      with the script's path)
%* copy and paste that command into the R Console and run
%  that command again
%  (both should print "Source: source document ..." along
%      with the script's path)
%* try closing all your documents and run that same command
%  in the R Console
%  (both should raise an error "R is being run ... with no
%      documents open")
%}
%
%tryCatch((function() {
%    .interactive <- interactive()
%    if (.interactive) {
%        cat("\\n")
%
%
%        ask <- function(question) {
%            prompt <- paste0(question, " (Yes/No/Cancel): ")
%            done <- FALSE
%            for (n in seq_len(100L)) {
%                response <- tolower(substr(readline(prompt), 1, 1))
%                if (response \%in\% c("y", "n", "c")) {
%                  done <- TRUE
%                  break
%                }
%            }
%            if (!done)
%                stop("unable to get response")
%            response
%        }
%
%
%        response <- ask("Would you like to run this example interactively?")
%        if (response == "c") {
%            cat("\\n")
%            return(invisible())
%        }
%        .interactive <- response == "y"
%    }
%    if (.interactive) {
%        pressEnter2Continue <- function(x = "\\n",
%            prompt = "Hit <Return> to continue: ") {
%            readline(prompt)
%            cat(x)
%        }
%    }
%    else pressEnter2Continue <- function(...) NULL
%
%
%    oopt <- options(useFancyQuotes = TRUE)
%    on.exit(options(oopt))
%
%
%    # minor change for macOS, normalize the 'tempdir' first
%    tmpdir <- normalizePath(tempdir(check = TRUE),
%        winslash = "/", mustWork = TRUE)
%
%
%    FILE <- tryCatch({
%        normalizePath(tempfile("scrp", tmpdir = tmpdir, fileext = ".R"),
%            winslash = "/", mustWork = FALSE)
%    }, condition = function(c) {
%        stop(errorCondition(paste0(conditionMessage(c),
%            "\\nunable to create temporary R script"),
%            call = conditionCall(c)))
%    })
%    on.exit(unlink(FILE), add = TRUE)
%
%
%    results.file <- tryCatch({
%        .Sys.time <- format(Sys.time(), "\%Y-\%m-\%d_\%H.\%M.\%OS_")
%        normalizePath(tempfile(paste0("rslt", .Sys.time),
%            tmpdir = tmpdir, fileext = ".txt"),
%            winslash = "/", mustWork = FALSE)
%    }, condition = base::as.null)
%    on.exit(unlink(results.file), add = TRUE)
%
%
%    write.results <- function(expr, split = FALSE) {
%        if (!is.null(results.file)) {
%            sink(file = results.file, append = TRUE, split = split)
%            on.exit(sink())
%        }
%        expr
%    }
%
%
%    cat2 <- function(msg, ..., appendLF = TRUE) {
%        cat(if (appendLF) "\\n", paste0(strwrap(msg, exdent = 2),
%            "\\n", collapse = ""), ..., sep = "")
%    }
%
%
%    FILEcode <- substitute({
%        options(useFancyQuotes = TRUE)
%        x <- `FILE sub`
%        results.file <- `results.file sub`
%        write.results <- `write.results sub`
%        cat2 <- `cat2 sub`
%        cat("\\n")
%        write.results({
%            y <- tryCatch({
%                this.path::this.path(verbose = TRUE)
%            }, condition = base::force)
%            cat("this.path status: ")
%        })
%        if (inherits(y, "condition")) {
%            msg <- conditionMessage(y)
%            call <- conditionCall(y)
%            write.results({
%                if (!is.null(call))
%                  cat("Error in ", deparse(call), " :\\n  ", msg, "\\n",
%                      sep = "")
%                else cat("Error: ", msg, "\\n", sep = "")
%            }, split = TRUE)
%            cat(sQuote("this.path"), " could not determine the executing ",
%                "script's filename\\n", sep = "")
%        }
%        else {
%            cat("Executing script's filename:\\n")
%            cat(sQuote(x), "\\n\\n", sep = "")
%            cat("Executing script's filename (as determined by ",
%                sQuote("this.path"), "):\\n", sep = "")
%            cat(sQuote(this.path::this.path(verbose = TRUE)), "\\n", sep = "")
%
%
%            if (x == y) {
%                write.results(cat("success\\n"))
%            }
%            else if (basename(dirname(x)) == basename(dirname(y)) &&
%                basename(x) == basename(y)) {
%                cat2(paste0(
%                    "Hmm ... looks like these paths are equivalent, it's ",
%                    "likely that they refer to the same file but have ",
%                    "different paths because of a hard link or multiple mounts",
%                    " (see ?normalizePath)"
%                ))
%                write.results(cat("success?\\n"))
%            }
%            else {
%                cat("\\n")
%                write.results({
%                    cat("Error: ", sQuote("this.path"), " could not correctly ",
%                        "determine the executing script's filename\\n", sep = "")
%                }, split = TRUE)
%            }
%        }
%    }, list(
%        `write.results sub` = write.results,
%        `FILE sub`          = FILE,
%        `results.file sub`  = results.file,
%        `cat2 sub`          = cat2
%    ))
%
%
%    tryCatch({
%        this.path:::write.code(FILEcode, FILE)
%    }, condition = function(c) {
%        stop(errorCondition(paste0(conditionMessage(c),
%            "\\nunable to write R code to file ", sQuote(FILE)),
%            call = conditionCall(c)))
%    })
%
%
%    cat2(paste0("Created an example R script. This script will be run in ",
%        "all possible ways that are compatible with ", sQuote("this.path"),
%        " that are currently available."))
%    if (.interactive) {
%        response <- ask("Would you like to see the script?")
%        if (response == "y") {
%            cat2(paste0("Attempting to open the example R script. If the ",
%                "script did not open automatically, the script's path is:"),
%                sQuote(normalizePath(FILE)), "\\n")
%            tryCatch({
%                this.path::file.open(FILE)
%            }, condition = base::invisible)
%            pressEnter2Continue("")
%        }
%    }
%
%
%    write.results(cat2(paste0("Attempting to use ", sQuote("this.path"),
%        " when using ", sQuote("source")), appendLF = FALSE))
%
%
%    tryCatch({
%        cat("\\n* first, using ", sQuote("source"), "\\n", sep = "")
%        source(FILE, local = TRUE)
%        pressEnter2Continue("")
%    }, condition = function(c) {
%        msg <- paste0(conditionMessage(c), "\\nunable to source file ",
%            sQuote(FILE))
%        call <- conditionCall(c)
%        if (!is.null(call))
%            cat("Error in ", deparse(call), " :\\n  ", msg, "\\n", sep = "")
%        else cat("Error: ", msg, "\\n", sep = "")
%    })
%
%
%    write.results(cat2(paste0("Attempting to use ", sQuote("this.path"),
%        " when using ", sQuote("sys.source"))))
%
%
%    tryCatch({
%        cat("\\n* second, using ", sQuote("sys.source"), "\\n", sep = "")
%        sys.source(FILE, envir = environment())
%        pressEnter2Continue("")
%    }, condition = function(c) {
%        msg <- paste0(conditionMessage(c), "\\nunable to source file ",
%            sQuote(FILE))
%        call <- conditionCall(c)
%        if (!is.null(call))
%            cat("Error in ", deparse(call), " :\\n  ", msg, "\\n", sep = "")
%        else cat("Error: ", msg, "\\n", sep = "")
%    })
%
%
%    if (.Platform$GUI == "RStudio") {
%        write.results(cat2(paste0("Attempting to use ", sQuote("this.path"),
%            " when using ", sQuote("debugSource"))))
%
%
%        tryCatch({
%            cat("\\n* third, using ", sQuote("debugSource"),
%                " from ", sQuote("RStudio"), "\\n", sep = "")
%            debug.source <- this.path:::tools.rstudio("debugSource")
%            debug.source(FILE, local = TRUE)
%            pressEnter2Continue("")
%        }, condition = function(c) {
%            msg <- paste0(conditionMessage(c), "\\nunable to source file ",
%                sQuote(FILE))
%            call <- conditionCall(c)
%            if (!is.null(call))
%                cat("Error in ", deparse(call), " :\\n  ", msg, "\\n", sep = "")
%            else cat("Error: ", msg, "\\n", sep = "")
%        })
%    }
%    else write.results({
%        cat2(paste0("Unfortunately, it is impossible to demonstrate the ",
%            "functionality of ", sQuote("this.path"), " when using ",
%            sQuote("debugSource"), " because ", sQuote("RStudio"), " is not ",
%            "presently running."))
%    })
%
%
%    if (!isNamespaceLoaded("testthat")) {
%        if (.interactive) {
%            cat2(paste0(sQuote("this.path"), " also works with function ",
%                sQuote("source_file"), " from package ", sQuote("testthat"),
%                ", but this package is not presently loaded."))
%            response <- ask("Would you like to load this package?")
%        }
%        else response <- "y"
%        if (response == "y") {
%            if (requireNamespace("testthat", quietly = TRUE)) {
%                on.exit(unloadNamespace("testthat"), add = TRUE)
%                cat2(paste0("Package ", sQuote("testthat"), " will be ",
%                  "unloaded once the example concludes."))
%            }
%            else if (.interactive && !"testthat" \%in\%
%                rownames(utils::installed.packages())) {
%                cat2(paste0("Package ", sQuote("testthat"), " was not ",
%                  "successfully loaded, possibly because it is not installed."))
%                response <- ask("Would you like to install this package?")
%                if (response == "y") {
%                  cat("\\n")
%                  tryCatch({
%                    utils::install.packages("testthat")
%                  }, error = base::invisible)
%                  if (requireNamespace("testthat", quietly = TRUE)) {
%                    on.exit(unloadNamespace("testthat"), add = TRUE)
%                    cat2(paste0("Package ", sQuote("testthat"), " will be ",
%                      "unloaded once the example concludes."))
%                  }
%                  else cat2(paste0("Package ", sQuote("testthat"), " was not ",
%                    "successfully installed and loaded."))
%                }
%            }
%            else cat2(paste0("Package ", sQuote("testthat"), " was not ",
%                "successfully loaded."))
%        }
%    }
%    if (isNamespaceLoaded("testthat")) {
%        write.results(cat2(paste0("Attempting to use ", sQuote("this.path"),
%            " when using ", sQuote("testthat::source_file"))))
%
%
%        tryCatch({
%            cat("\\n* ", if (.Platform$GUI != "RStudio")
%                "third"
%            else "fourth", ", using ", sQuote("testthat::source_file"), "\\n",
%                sep = "")
%            testthat::source_file(FILE)
%            pressEnter2Continue("")
%        }, condition = function(c) {
%            msg <- paste0(conditionMessage(c), "\\nunable to source file ",
%                sQuote(FILE))
%            call <- conditionCall(c)
%            if (!is.null(call))
%                cat("Error in ", deparse(call), " :\\n  ", msg, "\\n", sep = "")
%            else cat("Error: ", msg, "\\n", sep = "")
%        })
%    }
%    else write.results({
%        cat2(paste0("Unfortunately, it is impossible to demonstrate the ",
%            "functionality of ", sQuote("this.path"), " when using ",
%            sQuote("source_file"), " because package ", sQuote("testthat"),
%            " is not presently loaded."))
%    })
%
%
%    cmt <- if (.Platform$OS.type == "windows")
%        "Windows command-line"
%    else "Unix terminal"
%    write.results(cat2(paste0("Attempting to use ", sQuote("this.path"),
%        " when running from the ", cmt)))
%
%
%    tryCatch({
%        cat("\\n* last, running from the ", cmt, "\\n\\n", sep = "")
%        this.path::Rscript("--default-packages=NULL", FILE)
%        pressEnter2Continue()
%    }, condition = function(c) {
%        msg <- paste0(conditionMessage(c), "\\nunable to run file ",
%            sQuote(FILE), "\\n from the ", cmt)
%        call <- conditionCall(c)
%        if (!is.null(call))
%            cat("Error in ", deparse(call), " :\\n  ", msg, "\\n", sep = "")
%        else cat("Error: ", msg, "\\n", sep = "")
%    })
%
%
%    write.results({
%        cat2(paste0("Unfortunately, it is impossible to use ",
%            sQuote("example(this.path)"), " to demonstrate the functionality ",
%            "of ", sQuote("this.path"), " in ", sQuote("RStudio"), " and ",
%            sQuote("Rgui"), ". If you would like to see this functionality, ",
%            "you could try this:"),
%            "* make a new R script containing just this one command:\\n",
%            "    this.path::this.path(verbose = TRUE)\\n",
%            "* open this script in ", sQuote("RStudio"), " or ", sQuote("Rgui"),
%                "\\n",
%            "* run that command directly from the script\\n",
%            "    (both should print \\"Source: active document ...\\" along ",
%                "with the script's path)\\n",
%            "* copy and paste that command into the R Console and run that ",
%                "command again\\n",
%            "    (both should print \\"Source: source document ...\\" along ",
%                "with the script's path)\\n",
%            "* try closing all your documents and run that same command in ",
%                "the R Console\\n",
%            "    (both should raise an error \\"R is being run ... with no ",
%                "documents open\\")\\n")
%    })
%
%
%    write.results({
%        cat2(paste0("If ", sQuote("this.path"), " did not correctly determine ",
%            "the executing script's filename, please send a bug report ",
%            "using:"), "\\nutils::bug.report(package = \\"this.path\\")\\n")
%    })
%
%
%    if (.interactive) {
%        this.path::file.open(results.file)
%        pressEnter2Continue(prompt = "Hit <Return> to delete tempfiles: ")
%    }
%    else if (!is.null(results.file)) {
%        cat("\\n* results\\n\\n")
%        writeLines(readLines(results.file))
%    }
%    invisible()
%})(), error = function(c) {
%    msg <- conditionMessage(c)
%    call <- conditionCall(c)
%    if (!is.null(call))
%        cat("Error in ", deparse(call), " :\\n  ", msg, "\\n", sep = "")
%    else cat("Error: ", msg, "\\n", sep = "")
%})
%
%
%
%
%
\examples{\dontshow{.unload <- !isNamespaceLoaded("testthat")}
this.path:::write.code(file = FILE <- tempfile(), {

    withAutoprint({


        cat(sQuote(this.path::this.path(verbose = TRUE, default = {
            stop("interestingly enough, because the executing script's\n",
                "  path will be found, argument 'default' won't be evaluated,\n",
                "  and so this error won't actually print, isn't that\n",
                "  neat? you can use this to your advantage in a similar\n",
                "  manner, doing arbitrary things only if the executing\n",
                "  script does not exist")
        })), "\\n\\n")


    }, verbose = FALSE)

})


source(FILE, verbose = FALSE)
sys.source(FILE, envir = environment())
if (.Platform$GUI == "RStudio")
    get("debugSource", "tools:rstudio", inherits = FALSE)(FILE)
if (requireNamespace("testthat"))
    testthat::source_file(FILE, chdir = FALSE, wrap = FALSE)


this.path:::.Rscript(c("--default-packages=NULL", "--vanilla", FILE))


# this.path also works when source-ing a URL
# (included tryCatch in case an internet connection is not available)
tryCatch({
    source("https://raw.githubusercontent.com/ArcadeAntics/this.path/main/tests/this.path_w_URLs.R")
}, condition = base::message)


for (expr in c("this.path()",
               "this.path(default = NULL)",
               "this.dir()",
               "this.dir(default = NULL)",
               "this.dir(default = getwd())"))
    this.path:::.Rscript(c("--default-packages=this.path", "--vanilla", "-e", expr))
\dontshow{unlink(FILE) ; if (.unload) unloadNamespace("testthat")}}
