#' Grouping of Sustainable Development Goals (SDGs)
#' 
#' A dataset containing grouping of SDGs by 23 respondents 
#' 
#' @format A data frame with 23 rows and 18 variables: 
#' \describe{
#'  \item{ID}{ID number of respondent}
#'  \item{No_Poverty}{SDG 1 on no poverty}
#'  \item{Zero_Hunger}{SDG 2 on zero hunger}
#'  \item{Good_Health_and_Well_Being}{SDG 3 on good health and wellbeing}
#'  \item{Quality_Education}{SDG 4 on quality education}
#'  \item{Gender_Equality}{SDG 5 on gender equality}
#'  \item{Clean_Water_and_Sanitation}{SDG 6 on clean water and sanitation}
#'  \item{Affordable_and_Clean_Energy}{SDG 7 on affordable and clean energy}
#'  \item{Decent_Work_and_Economic_Growth}{SDG 8 on decent work and economic growth}
#'  \item{Industry_Innovation_and_Infrastructure}{SDG 9 on industry innovation and infrastructure}
#'  \item{Reduced_Inequalities}{SDG 10 on reduced inequalities}
#'  \item{Sustainable_Cities_and_Communities}{SDG 11 on sustainable cities and communities}
#'  \item{Responsible_Consumption_and_Production}{SDG 12 on responsible consumption and production}
#'  \item{Climate_Action}{SDG 13 on climate action}
#'  \item{Life_Below_Water}{SDG 14 on life below water}
#'  \item{Life_on_Land}{SDG 15 on life on land}
#'  \item{Peace_Justice_and_Strong_Institutions}{SDG 16 on peace, justice, and strong institutions}
#'  \item{Partnerships_for_the_Goals}{SDG 17 on partnerships for the goals}
#'  }
#' @source {Data collected by the Social Research and Methodology Group, University of Basel, Switzerland. For more details on the SDGs see <www.sustainabledevelopment.un.org>.}
"SDG_grouping"

#' Co-occurence of Sustainable Development Goals (SDGs)
#' 
#' A dataset containing rating of SDGs in terms of importance by 23 respondents 
#' 
#' @format A data frame with 46 rows and 19 variables: 
#' \describe{
#'  \item{ID}{ID number of respondent}
#'  \item{Important_q}{Indicates if selection represents important goals (1) or 
#'  unimportant goals (0) as perceived by respondent}
#'  \item{No_Poverty}{SDG 1 on no poverty}
#'  \item{Zero_Hunger}{SDG 2 on zero hunger}
#'  \item{Good_Health_and_Well_Being}{SDG 3 on good health and wellbeing}
#'  \item{Quality_Education}{SDG 4 on quality education}
#'  \item{Gender_Equality}{SDG 5 on gender equality}
#'  \item{Clean_Water_and_Sanitation}{SDG 6 on clean water and sanitation}
#'  \item{Affordable_and_Clean_Energy}{SDG 7 on affordable and clean energy}
#'  \item{Decent_Work_and_Economic_Growth}{SDG 8 on decent work and economic growth}
#'  \item{Industry_Innovation_and_Infrastructure}{SDG 9 on industry innovation and infrastructure}
#'  \item{Reduced_Inequalities}{SDG 10 on reduced inequalities}
#'  \item{Sustainable_Cities_and_Communities}{SDG 11 on sustainable cities and communities}
#'  \item{Responsible_Consumption_and_Production}{SDG 12 on responsible consumption and production}
#'  \item{Climate_Action}{SDG 13 on climate action}
#'  \item{Life_Below_Water}{SDG 14 on life below water}
#'  \item{Life_on_Land}{SDG 15 on life on land}
#'  \item{Peace_Justice_and_Strong_Institutions}{SDG 16 on peace, justice, and strong institutions}
#'  \item{Partnerships_for_the_Goals}{SDG 17 on partnerships for the goals}
#'  }
#' @source {Data collected by the Social Research and Methodology Group, University of Basel, Switzerland. For more details on the SDGs see <www.sustainabledevelopment.un.org>.}
"SDG_coocurrence"