% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_viewer.R
\name{view_run_metrics}
\alias{view_run_metrics}
\alias{update_run_metrics}
\title{View metrics for a training run}
\usage{
view_run_metrics(metrics)

update_run_metrics(viewer, metrics)
}
\arguments{
\item{metrics}{Data frame containing run metrics}

\item{viewer}{Viewer object returned from \code{view_run_metrics()}.}
}
\description{
Interactive D3 visualization of metrics for a training run. Metrics will
be displayed in the RStudio Viewer (if available), otherwise will be
displayed in an external web browser.
}
\note{
Metrics named \code{"acc"} or \code{"accuracy"} will automatically use \code{1.0} as the
maximum value on their y-axis scale.
}
\section{Metrics Data Frame}{


Metrics should be passed as a data frame with one column for each metric.
If the metrics are not yet complete (e.g. only metrics for the
first several epochs are provided) then metrics in yet to be completed
epochs should use \code{NA} as their values. For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{data.frame':	30 obs. of  4 variables:
$ loss    : num  0.423 0.201 NA NA NA ...
$ acc     : num  0.873 0.942 NA NA NA ...
$ val_loss: num  0.174 0.121 NA NA NA ...
$ val_acc : num  0.949 0.964 NA NA NA ...
}\if{html}{\out{</div>}}

If both metrics and validation metrics are provided, you should preface the
name of the validation metric with \code{"val_"} (e.g. for a metric named \code{"loss"}
provide validation metrics in \code{"val_loss"}). This indicates that the metrics
are related which is useful e.g. when plotting metrics.
}

\section{Realtime Updates}{


Metrics can be updated in real-time by calling the \code{update_run_metrics()}
with the run viewer instance returned from \code{view_run_metrics()}. For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# view metrics
viewer <- view_run_metrics(metrics)

# update with new metrics
update_run_metrics(viewer, updated_metrics)
}\if{html}{\out{</div>}}
}

\seealso{
write_run_metrics
}
