% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_estimators.R
\name{linear_estimators}
\alias{linear_estimators}
\alias{linear_regressor}
\alias{linear_classifier}
\title{Construct a Linear Estimator}
\usage{
linear_regressor(feature_columns, model_dir = NULL,
  label_dimension = 1L, weight_column = NULL, optimizer = "Ftrl",
  config = NULL, partitioner = NULL)

linear_classifier(feature_columns, model_dir = NULL, n_classes = 2L,
  weight_column = NULL, label_vocabulary = NULL, optimizer = "Ftrl",
  config = NULL, partitioner = NULL)
}
\arguments{
\item{feature_columns}{An \R list containing all of the feature columns used
by the model (typically, generated by \code{\link[=feature_columns]{feature_columns()}}).}

\item{model_dir}{Directory to save the model parameters, graph, and so on.
This can also be used to load checkpoints from the directory into a
estimator to continue training a previously saved model.}

\item{label_dimension}{Number of regression targets per example. This is the
size of the last dimension of the labels and logits \code{Tensor} objects
(typically, these have shape \code{[batch_size, label_dimension]}).}

\item{weight_column}{A string, or a numeric column created by
\code{\link[=column_numeric]{column_numeric()}} defining feature column representing weights. It is used
to down weight or boost examples during training. It will be multiplied by
the loss of the example. If it is a string, it is used as a key to fetch
weight tensor from the \code{features} argument. If it is a numeric column,
then the raw tensor is fetched by key \code{weight_column$key}, then
\code{weight_column$normalizer_fn} is applied on it to get weight tensor.}

\item{optimizer}{Either the name of the optimizer to be used when training
the model, or a TensorFlow optimizer instance. Defaults to the FTRL
optimizer.}

\item{config}{A run configuration created by \code{\link[=run_config]{run_config()}}, used to configure the runtime
settings.}

\item{partitioner}{An optional partitioner for the input layer.}

\item{n_classes}{The number of label classes.}

\item{label_vocabulary}{A list of strings represents possible label values.
If given, labels must be string type and have any value in
\code{label_vocabulary}. If it is not given, that means labels are already
encoded as integer or float within \code{[0, 1]} for \code{n_classes == 2} and
encoded as integer values in \code{{0, 1,..., n_classes -1}} for \code{n_classes > 2}. Also there will be errors if vocabulary is not provided and labels are
string.}
}
\description{
Construct a linear model, which can be used to predict a continuous outcome
(in the case of \code{linear_regressor()}) or a categorical outcome (in the case
of \code{linear_classifier()}).
}
\seealso{
Other canned estimators: \code{\link{boosted_trees_estimators}},
  \code{\link{dnn_estimators}},
  \code{\link{dnn_linear_combined_estimators}}
}
\concept{canned estimators}
