% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_batch}
\alias{dataset_batch}
\title{Combines consecutive elements of this dataset into batches.}
\usage{
dataset_batch(
  dataset,
  batch_size,
  drop_remainder = FALSE,
  num_parallel_calls = NULL,
  deterministic = NULL
)
}
\arguments{
\item{dataset}{A dataset}

\item{batch_size}{An integer, representing the number of consecutive elements
of this dataset to combine in a single batch.}

\item{drop_remainder}{(Optional.) A boolean, representing whether the last
batch should be dropped in the case it has fewer than \code{batch_size}
elements; the default behavior is not to drop the smaller batch.}

\item{num_parallel_calls}{(Optional.) A scalar integer, representing the
number of batches to compute asynchronously in parallel. If not specified,
batches will be computed sequentially. If the value \code{tf$data$AUTOTUNE} is
used, then the number of parallel calls is set dynamically based on
available resources.}

\item{deterministic}{(Optional.) When \code{num_parallel_calls} is specified, if
this boolean is specified (\code{TRUE} or \code{FALSE}), it controls the order in
which the transformation produces elements. If set to \code{FALSE}, the
transformation is allowed to yield elements out of order to trade
determinism for performance. If not specified, the
\code{tf.data.Options.experimental_deterministic} option (\code{TRUE} by default)
controls the behavior. See \code{dataset_options()} for how to set dataset
options.}
}
\value{
A dataset
}
\description{
The components of the resulting element will have an additional outer
dimension, which will be \code{batch_size} (or \code{N \%\% batch_size} for the last
element if \code{batch_size} does not divide the number of input elements \code{N}
evenly and \code{drop_remainder} is \code{FALSE}). If your program depends on the
batches having the same outer dimension, you should set the \code{drop_remainder}
argument to \code{TRUE} to prevent the smaller batch from being produced.
}
\note{
If your program requires data to have a statically known shape (e.g.,
when using XLA), you should use \code{drop_remainder=TRUE}. Without
\code{drop_remainder=TRUE} the shape of the output dataset will have an unknown
leading dimension due to the possibility of a smaller final batch.
}
\seealso{
Other dataset methods: 
\code{\link{dataset_cache}()},
\code{\link{dataset_collect}()},
\code{\link{dataset_concatenate}()},
\code{\link{dataset_decode_delim}()},
\code{\link{dataset_filter}()},
\code{\link{dataset_interleave}()},
\code{\link{dataset_map_and_batch}()},
\code{\link{dataset_map}()},
\code{\link{dataset_padded_batch}()},
\code{\link{dataset_prefetch_to_device}()},
\code{\link{dataset_prefetch}()},
\code{\link{dataset_reduce}()},
\code{\link{dataset_repeat}()},
\code{\link{dataset_shuffle_and_repeat}()},
\code{\link{dataset_shuffle}()},
\code{\link{dataset_skip}()},
\code{\link{dataset_take}()},
\code{\link{dataset_window}()}
}
\concept{dataset methods}
