% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_list.R
\name{tidy_list}
\alias{tidy_list}
\title{Tidy a List of Named Dataframes or Vectors}
\usage{
tidy_list(x, id.name = "id", content.name = "content",
  as.tibble = tibble_output(), ...)
}
\arguments{
\item{x}{A named \code{\link[base]{list}} of
\code{\link[base]{data.frame}}s or \code{\link[base]{vector}}.}

\item{id.name}{The name to use for the column created from the \code{\link[base]{list}}.}

\item{content.name}{The name to use for the column created from the \code{\link[base]{list}}
of \code{\link[base]{vector}}s (only used if \code{x} is  \code{\link[base]{vector}}).}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{Ignored.}
}
\value{
Returns a \code{\link[data.table]{data.table}} with the \code{\link[base]{names}}
from the \code{\link[base]{list}} as an \code{id} column.
}
\description{
\code{\link[base]{rbind}} a named \code{\link[base]{list}} of
\code{\link[base]{data.frame}}s or \code{\link[base]{vector}}s to
output a single \code{\link[base]{data.frame}} with the \code{\link[base]{names}}
from the \code{\link[base]{list}} as an \code{id} column.
}
\examples{
tidy_list(list(p=1:500, r=letters))
tidy_list(list(p=mtcars, r=mtcars, z=mtcars, d=mtcars))

\dontrun{
## 2015 Vice-Presidential Debates Example
if (!require("pacman")) install.packages("pacman")
pacman::p_load(rvest, magrittr, xml2)

debates <- c(
    wisconsin = "110908",
    boulder = "110906",
    california = "110756",
    ohio = "110489"
)

lapply(debates, function(x){
    xml2::read_html(paste0("http://www.presidency.ucsb.edu/ws/index.php?pid=", x)) \%>\%
        rvest::html_nodes("p") \%>\%
        rvest::html_text() \%>\%
        textshape::split_index(grep("^[A-Z]+:", .)) \%>\%
        textshape::combine() \%>\%
        textshape::split_transcript() \%>\%
        textshape::split_sentence()
}) \%>\%
    textshape::tidy_list("location")
}
}

