% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_time.R
\name{replace_time}
\alias{replace_time}
\title{Replace Time Stamps With Words}
\usage{
replace_time(x,
  pattern = "(2[0-3]|[01]?[0-9]):([0-5][0-9])[.:]?([0-5]?[0-9])?",
  replacement = NULL, ...)
}
\arguments{
\item{x}{The text variable.}

\item{pattern}{Character time regex string to be matched in the given 
character vector.}

\item{replacement}{A function to operate on the extracted matches or a 
character string which is a replacement for the matched pattern.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector with the pattern replaced.
}
\description{
Replaces time stamps with word equivalents.
}
\examples{
x <- c(
    NA, '12:47 to "twelve forty-seven" and also 8:35:02', 
    'what about 14:24.5', 'And then 99:99:99?'
)

## Textual: Word version
replace_time(x)

## Normalization: <<TIME>>
replace_time(x, replacement = '<<TIME>>')

## Normalization: hh:mm:ss or hh:mm
replace_time(x, replacement = function(y){
        z <- unlist(strsplit(y, '[:.]'))
        z[1] <- 'hh'
        z[2] <- 'mm'
        if(!is.na(z[3])) z[3] <- 'ss'
        collapse(z, ':')
    }
)

## Textual: Word version (forced seconds)
replace_time(x, replacement = function(y){
        z <- replace_number(unlist(strsplit(y, '[:.]')))
        z[3] <- paste0('and ', ifelse(is.na(z[3]), '0', z[3]), ' seconds')
        paste(z, collapse = ' ')
    }
)
 
## Normalization: hh:mm:ss
replace_time(x, replacement = function(y){
        z <- unlist(strsplit(y, '[:.]'))
        z[1] <- 'hh'
        z[2] <- 'mm'
        z[3] <- 'ss'
        collapse(z, ':')
    }
)
}
