% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_tokens.R
\name{match_tokens}
\alias{match_tokens}
\title{Find Tokens that Match a Regex}
\usage{
match_tokens(x, pattern, ignore.case = TRUE, ...)
}
\arguments{
\item{x}{A character vector.}

\item{pattern}{Character string(s) to be matched in the given character vector.}

\item{ignore.case}{logical.  If \code{TRUE} the case of the tokens/patterns 
will be ignored.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector of tokens from a text matching a specific regex 
pattern.
}
\description{
Given a text, find all the tokens that match a regex(es).  This function is
particularly useful with \code{\link[textclean]{replace_tokens}}.
}
\examples{
with(DATA, match_tokens(state, c('^li', 'ou')))

with(DATA, match_tokens(state, c('^Th', '^I'), ignore.case = TRUE))
with(DATA, match_tokens(state, c('^Th', '^I'), ignore.case = FALSE))
}
\seealso{
\code{\link[textclean]{replace_tokens}}
}
