% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_element.R
\name{drop_element}
\alias{drop_element}
\alias{drop_element_regex}
\alias{drop_element_fixed}
\alias{keep_element}
\alias{keep_element_fixed}
\alias{keep_element_regex}
\title{Filter Elements in a Vetor}
\usage{
drop_element(x, pattern, regex = TRUE, ...)

drop_element_regex(x, pattern, ...)

drop_element_fixed(x, ...)

keep_element(x, pattern, regex = TRUE, ...)

keep_element_fixed(x, ...)

keep_element_regex(x, pattern, ...)
}
\arguments{
\item{x}{A character vector.}

\item{pattern}{A regex pattern to match for exclusion.}

\item{regex}{logical.  If setting this to \code{TRUE} please use 
\code{drop_element_regex} or \code{keep_element_regex} directly as this will
provide better control and optimization.}

\item{\ldots}{Other arguments passed to \code{\link[base]{grep}} if 
\code{regex}.  If \code{fixed}, then elements to drop/keep.}
}
\value{
Returns a vector with matching elements removed.
}
\description{
\code{drop_element} - Filter to drop the matching elements of a vector.

\code{keep_element} - Filter to keep the matching elements of a vector.
}
\examples{
x <- c('dog', 'cat', 'bat', 'dingo', 'dragon', 'dino')
drop_element(x, '^d.+?g')
keep_element(x, '^d.+?g')
drop_element(x, 'at$')
drop_element(x, '^d')
drop_element(x, '\\\\b(dog|cat)\\\\b')

drop_element_fixed(x, 'bat', 'cat')
drops <- c('bat', 'cat')
drop_element_fixed(x, drops)
}
