% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quasi-label.R
\name{quasi_label}
\alias{quasi_label}
\title{Quasi-labelling}
\usage{
quasi_label(quo, label = NULL, arg = "quo")
}
\arguments{
\item{quo}{A quosure created by \code{rlang::enquo()}.}

\item{label}{An optional label to override the default. This is
only provided for internal usage. Modern expectations should not
include a \code{label} parameter.}

\item{arg}{Argument name shown in error message if \code{quo} is missing.}
}
\value{
A list containing two elements:
\item{val}{The evaluate value of \code{quo}}
\item{lab}{The quasiquoted label generated from \code{quo}}
}
\description{
The first argument to every \code{expect_} function can use unquoting to
construct better labels. This makes it easy to create informative labels
expectations are used inside a function or a for loop. \code{quasi_label()} wraps
up the details, returning the expression and label.
}
\section{Limitations}{

Because all \code{expect_} function use unquoting to generate more informative
labels, you can not use unquoting for other purposes. Instead, you'll need
to perform all other unquoting outside of the expectation and only test
the results.
}

\examples{
f <- function(i) if (i > 3) i * 9 else i * 10
i <- 10

# This short of expression commonly occurs inside a for loop or function
# And the failure isn't helpful because you can't see the value of i
# that caused the problem:
show_failure(expect_equal(f(i), i * 10))

# To overcome this issue, testthat allows you to unquote expressions using
# !!. This causes the failure message to show the value rather than the
# variable name
show_failure(expect_equal(f(!!i), !!(i * 10)))
}
\keyword{internal}
