% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-named.R
\name{expect_named}
\alias{expect_named}
\title{Expectation: does object have names?}
\usage{
expect_named(object, expected, ignore.order = FALSE, ignore.case = FALSE,
  info = NULL, label = NULL)
}
\arguments{
\item{object}{object to test}

\item{expected}{Character vector of expected names. Leave missing to
match any names. Use \code{NULL} to check for absence of names.}

\item{ignore.order}{If \code{TRUE}, sorts names before comparing to
ignore the effect of order.}

\item{ignore.case}{If \code{TRUE}, lowercases all names to ignore the
effect of case.}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}

\item{...}{Other arguments passed onto \code{has_names}.}
}
\description{
You can either check for the presence of names (leaving \code{expected}
blank), specific names (by suppling a vector of names), or absence of
names (with \code{NULL}).
}
\examples{
x <- c(a = 1, b = 2, c = 3)
expect_named(x)
expect_named(x, c("a", "b", "c"))

# Use options to control sensitivity
expect_named(x, c("B", "C", "A"), ignore.order = TRUE, ignore.case = TRUE)

# Can also check for the absence of names with NULL
z <- 1:4
expect_named(z, NULL)
}
\seealso{
Other expectations: \code{\link{comparison-expectations}},
  \code{\link{equality-expectations}},
  \code{\link{expect_equal_to_reference}},
  \code{\link{expect_length}}, \code{\link{expect_match}},
  \code{\link{inheritance-expectations}},
  \code{\link{logical-expectations}},
  \code{\link{output-expectations}}
}

