% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{clogit_with_tryCatch}
\alias{clogit_with_tryCatch}
\title{Wrapper function of survival::clogit}
\usage{
clogit_with_tryCatch(formula, data, ...)
}
\arguments{
\item{formula}{Model formula.}

\item{data}{data frame.}

\item{...}{further parameters to be added to survival::clogit.}
}
\value{
When model fitting is successful, an object of class "clogit".\cr
When model fitting failed, an error message is shown.
}
\description{
When model fitting failed, a more useful message would show.
}
\examples{
\dontrun{
library(dplyr)
adrs_local <- tern_ex_adrs \%>\%
  dplyr::filter(ARMCD \%in\% c("ARM A", "ARM B")) \%>\%
  dplyr::mutate(
    RSP = dplyr::case_when(AVALC \%in\% c("PR", "CR") ~ 1, TRUE ~ 0),
    ARMBIN = droplevels(ARMCD)
  )
dta <- adrs_local
dta <- dta[sample(nrow(dta)), ]
mod <- clogit_with_tryCatch(formula = RSP ~ ARMBIN * AGE + strata(STRATA1), data = dta)
}

}
