% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_duration_subgroups.R
\name{survival_duration_subgroups}
\alias{survival_duration_subgroups}
\alias{tabulate_survival_subgroups}
\alias{a_survival_subgroups}
\title{Tabulate survival duration by subgroup}
\usage{
tabulate_survival_subgroups(
  lyt,
  df,
  vars = c("n_tot_events", "n_events", "median", "hr", "ci"),
  groups_lists = list(),
  label_all = lifecycle::deprecated(),
  time_unit = NULL,
  riskdiff = NULL,
  na_str = default_na_str(),
  .formats = c(n = "xx", n_events = "xx", n_tot_events = "xx", median = "xx.x", n_tot =
    "xx", hr = list(format_extreme_values(2L)), ci = list(format_extreme_values_ci(2L)),
    pval = "x.xxxx | (<0.0001)")
)

a_survival_subgroups(
  .formats = list(n = "xx", n_events = "xx", n_tot_events = "xx", median = "xx.x", n_tot
    = "xx", hr = list(format_extreme_values(2L)), ci =
    list(format_extreme_values_ci(2L)), pval = "x.xxxx | (<0.0001)"),
  na_str = default_na_str()
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{df}{(\code{list})\cr list of data frames containing all analysis variables. List should be
created using \code{\link[=extract_survival_subgroups]{extract_survival_subgroups()}}.}

\item{vars}{(\code{character})\cr the names of statistics to be reported among:
\itemize{
\item \code{n_tot_events}: Total number of events per group.
\item \code{n_events}: Number of events per group.
\item \code{n_tot}: Total number of observations per group.
\item \code{n}: Number of observations per group.
\item \code{median}: Median survival time.
\item \code{hr}: Hazard ratio.
\item \code{ci}: Confidence interval of hazard ratio.
\item \code{pval}: p-value of the effect.
Note, one of the statistics \code{n_tot} and \code{n_tot_events}, as well as both \code{hr} and \code{ci}
are required.
}}

\item{groups_lists}{(named \code{list} of \code{list})\cr optionally contains for each \code{subgroups} variable a
list, which specifies the new group levels via the names and the
levels that belong to it in the character vectors that are elements of the list.}

\item{label_all}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}\cr please assign the \code{label_all} parameter within the
\code{\link[=extract_survival_subgroups]{extract_survival_subgroups()}} function when creating \code{df}.}

\item{time_unit}{(\code{string})\cr label with unit of median survival time. Default \code{NULL} skips displaying unit.}

\item{riskdiff}{(\code{list})\cr if a risk (proportion) difference column should be added, a list of settings to apply
within the column. See \code{\link[=control_riskdiff]{control_riskdiff()}} for details. If \code{NULL}, no risk difference column will be added. If
\code{riskdiff$arm_x} and \code{riskdiff$arm_y} are \code{NULL}, the first level of \code{df$survtime$arm} will be used as \code{arm_x}
and the second level as \code{arm_y}.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}
}
\value{
An \code{rtables} table summarizing survival by subgroup.

\itemize{
\item \code{a_survival_subgroups()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The \code{\link[=tabulate_survival_subgroups]{tabulate_survival_subgroups()}} function creates a layout element to tabulate survival duration by subgroup,
returning statistics including median survival time and hazard ratio for each population subgroup. The table is
created from \code{df}, a list of data frames returned by \code{\link[=extract_survival_subgroups]{extract_survival_subgroups()}}, with the statistics to include
specified via the \code{vars} parameter.

A forest plot can be created from the resulting table using the \code{\link[=g_forest]{g_forest()}} function.
}
\details{
These functions create a layout starting from a data frame which contains
the required statistics. Tables typically used as part of forest plot.
}
\section{Functions}{
\itemize{
\item \code{tabulate_survival_subgroups()}: Table-creating function which creates a table
summarizing survival by subgroup. This function is a wrapper for \code{\link[rtables:analyze_colvars]{rtables::analyze_colvars()}}
and \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}.

\item \code{a_survival_subgroups()}: Formatted analysis function which is used as
\code{afun} in \code{tabulate_survival_subgroups()}.

}}
\examples{
library(dplyr)

adtte <- tern_ex_adtte

# Save variable labels before data processing steps.
adtte_labels <- formatters::var_labels(adtte)

adtte_f <- adtte \%>\%
  filter(
    PARAMCD == "OS",
    ARM \%in\% c("B: Placebo", "A: Drug X"),
    SEX \%in\% c("M", "F")
  ) \%>\%
  mutate(
    # Reorder levels of ARM to display reference arm before treatment arm.
    ARM = droplevels(forcats::fct_relevel(ARM, "B: Placebo")),
    SEX = droplevels(SEX),
    AVALU = as.character(AVALU),
    is_event = CNSR == 0
  )
labels <- c(
  "ARM" = adtte_labels[["ARM"]],
  "SEX" = adtte_labels[["SEX"]],
  "AVALU" = adtte_labels[["AVALU"]],
  "is_event" = "Event Flag"
)
formatters::var_labels(adtte_f)[names(labels)] <- labels

df <- extract_survival_subgroups(
  variables = list(
    tte = "AVAL",
    is_event = "is_event",
    arm = "ARM", subgroups = c("SEX", "BMRKR2")
  ),
  label_all = "Total Patients",
  data = adtte_f
)
df

df_grouped <- extract_survival_subgroups(
  variables = list(
    tte = "AVAL",
    is_event = "is_event",
    arm = "ARM", subgroups = c("SEX", "BMRKR2")
  ),
  data = adtte_f,
  groups_lists = list(
    BMRKR2 = list(
      "low" = "LOW",
      "low/medium" = c("LOW", "MEDIUM"),
      "low/medium/high" = c("LOW", "MEDIUM", "HIGH")
    )
  )
)
df_grouped

## Table with default columns.
basic_table() \%>\%
  tabulate_survival_subgroups(df, time_unit = adtte_f$AVALU[1])

## Table with a manually chosen set of columns: adding "pval".
basic_table() \%>\%
  tabulate_survival_subgroups(
    df = df,
    vars = c("n_tot_events", "n_events", "median", "hr", "ci", "pval"),
    time_unit = adtte_f$AVALU[1]
  )

}
\seealso{
\code{\link[=extract_survival_subgroups]{extract_survival_subgroups()}}
}
\keyword{internal}
