% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_variables.R
\name{create_afun_summary}
\alias{create_afun_summary}
\title{Constructor Function for \code{\link[=summarize_vars]{summarize_vars()}} and \code{\link[=summarize_colvars]{summarize_colvars()}}}
\usage{
create_afun_summary(.stats, .formats, .labels, .indent_mods)
}
\arguments{
\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{vector} of \code{integer})\cr indent modifiers for the labels. Each element of the vector
should be a name-value pair with name corresponding to a statistic specified in \code{.stats} and value the indentation
for that statistic's row label.}
}
\value{
Combined formatted analysis function for use in \code{\link[=summarize_vars]{summarize_vars()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Constructor function which creates a combined formatted analysis function.
}
\note{
Since \code{\link[=a_summary]{a_summary()}} is generic and we want customization of the formatting arguments
via \code{\link[rtables:make_afun]{rtables::make_afun()}}, we need to create another temporary generic function, with
corresponding customized methods. Then in order for the methods to be found,
we need to wrap them in a combined \code{afun}. Since this is required by two layout creating
functions (and possibly others in the future), we provide a constructor that does this:
\code{\link[=create_afun_summary]{create_afun_summary()}}.
}
\examples{
# `create_afun_summary()` to create combined `afun`

afun <- create_afun_summary(
  .stats = NULL,
  .formats = c(median = "xx."),
  .labels = c(median = "My median"),
  .indent_mods = c(median = 1L)
)
## Fabricated dataset.
dta_test <- data.frame(
  USUBJID = rep(1:6, each = 3),
  PARAMCD = rep("lab", 6 * 3),
  AVISIT  = rep(paste0("V", 1:3), 6),
  ARM     = rep(LETTERS[1:3], rep(6, 3)),
  AVAL    = c(9:1, rep(NA, 9))
)

l <- basic_table() \%>\%
  split_cols_by(var = "ARM") \%>\%
  split_rows_by(var = "AVISIT") \%>\%
  analyze(vars = "AVAL", afun = afun)

build_table(l, df = dta_test)

}
