% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_data.R
\name{sas_na}
\alias{sas_na}
\title{Convert Strings to \code{NA}}
\usage{
sas_na(x, empty = TRUE, whitespaces = TRUE)
}
\arguments{
\item{x}{(\code{factor} or \code{character} vector)\cr values for which any missing values should be substituted.}

\item{empty}{(\code{logical})\cr if \code{TRUE} empty strings get replaced by \code{NA}.}

\item{whitespaces}{(\code{logical})\cr if \code{TRUE} then strings made from whitespaces only get replaced with \code{NA}.}
}
\value{
\code{x} with \code{""} and/or whitespace-only values substituted by \code{NA}, depending on the values of
\code{empty} and \code{whitespaces}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

SAS imports missing data as empty strings or strings with whitespaces only. This helper function can be used to
convert these values to \code{NA}s.
}
\examples{
sas_na(c("1", "", " ", "   ", "b"))
sas_na(factor(c("", " ", "b")))

is.na(sas_na(c("1", "", " ", "   ", "b")))

}
