% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan_meier_plot.R
\name{h_grob_median_surv}
\alias{h_grob_median_surv}
\title{Helper Function: Survival Estimation Grob}
\usage{
h_grob_median_surv(
  fit_km,
  armval = "All",
  x = 0.9,
  y = 0.9,
  width = grid::unit(0.3, "npc"),
  ttheme = gridExtra::ttheme_default()
)
}
\arguments{
\item{fit_km}{(\code{survfit})\cr result of \code{\link[survival:survfit]{survival::survfit()}}.}

\item{armval}{(\code{string})\cr used as strata name when treatment arm variable only has one level. Default is "All".}

\item{x}{(\code{numeric})\cr a value between 0 and 1 specifying x-location.}

\item{y}{(\code{numeric})\cr a value between 0 and 1 specifying y-location.}

\item{width}{(\code{unit})\cr width (as a unit) to use when printing the grob.}

\item{ttheme}{(\code{list})\cr see \code{\link[gridExtra:tableGrob]{gridExtra::ttheme_default()}}.}
}
\value{
A \code{grob} of a table containing statistics \code{N}, \code{Median}, and \verb{XX\% CI} (\code{XX} taken from \code{fit_km}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The survival fit is transformed in a grob containing a table with groups in
rows characterized by N, median and 95\% confidence interval.
}
\examples{
\donttest{
library(dplyr)
library(survival)
library(grid)

grid::grid.newpage()
grid.rect(gp = grid::gpar(lty = 1, col = "pink", fill = "gray85", lwd = 1))
tern_ex_adtte \%>\%
  filter(PARAMCD == "OS") \%>\%
  survfit(form = Surv(AVAL, 1 - CNSR) ~ ARMCD, data = .) \%>\%
  h_grob_median_surv() \%>\%
  grid::grid.draw()
}

}
