\name{termstrc-package}
\alias{termstrc-package}
\alias{termstrc}
\docType{package}


\title{
Zero-coupon Yield Curve Estimation
}


\description{
Zero-coupon yield curves and spread curves are important inputs for various financial models, e.g. pricing of securities, risk management, monetary policy issues. Since zero-coupon rates are rarely directly observable, they have to be estimated from market data. The literature broadly distinguishes between parametric and spline-based estimation methods for the zero-coupon yield curve. Our package consists of several widely-used approaches, i.e. the parametric Nelson and Siegel (1987) method with the Svensson (1994) extension, and the McCulloch (1975) cubic splines approach. Extensive summary statistics and plots are provided to compare the results of the different estimation methods.
}

\references{

Bank for International Settlements (2005).
Zero-Coupon Yield Curves: Technical Documentation.
\emph{BIS Papers, \bold{No. 25}}.


Robert R. Bliss (2007):
Testing Term Structure Estimation Methods.
\emph{Advances in Futures and Options Research, \bold{9} 197--232}. 


David Bolder and David Streliski (1999):
Yield Curve Modelling at the Bank of Canada.
\emph{Bank of Canada Technical Report, \bold{No. 84}}.


Alois Geyer and Richard Mader (1999):
Estimation of the Term Structure of Interest Rates - A Parametric Approach.
\emph{OeNB Working Paper, \bold{No. 37}}.


Michalis Ioannides (2003):
A Comparison of Yield Curve Estimation Techniques Using UK Data.
\emph{Journal of Banking \& Finance, \bold{27} 1--26}. 


J. Huston McCulloch (1971):
Measuring the Term Structure of Interest Rates.
\emph{The Journal of Business, \bold{44} 19--31}. 

J. Huston McCulloch (1975):
The Tax-Adjusted Yield Curve.
\emph{The Journal of Finance, \bold{30} 811--830}. 


Charles R. Nelson and Andrew F. Siegel (1987): 
Parsimonious Modeling of Yield Curves.
\emph{The Journal of Business}, \bold{60(4)}:473--489.


Lars E.O. Svensson (1994): 
Estimating and Interpreting Forward Interest Rates: Sweden 1992 -1994. 
\emph{Technical Reports 4871, National Bureau of Economic Research}. 
 
}

\keyword{package}
