% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.data.R
\name{get.data}
\alias{get.data}
\title{Generate a random tensor}
\usage{
get.data(n, p, q, k = NULL, r = NULL, l = NULL, error = 3,
  sort = TRUE, sparse.percent = 0, multiplicative = 0,
  center = FALSE, seed = NULL, mumin = -3, mumax = 3)
}
\arguments{
\item{n}{the dimension of mode 1}

\item{p}{the dimension of mode 2}

\item{q}{the dimension of mode 3}

\item{k}{\eqn{d_1}: the clusters number of mode 1}

\item{r}{\eqn{d_2}: the clusters number of mode 2}

\item{l}{\eqn{d_3}: the clusters number of mode 3}

\item{error}{positive numeric value: the noise in rnorm()}

\item{sort}{if TRUE, the data belongs to the same clusters would assemble together after sorting}

\item{sparse.percent}{the proportion of 0 mean in normal case; the proportion of 0 of each vector in multiplicative case}

\item{multiplicative}{if multiplicative !=0, then it would produce overlapping multiplicative data, the number refers to the number of components.}

\item{center}{logic value that indicates whether run "x = x-mean(x)" before performing clustering.}

\item{seed}{default is NULL, otherwise would set seed to corresponding point}

\item{mumin}{numeric value. The lower bound of mu when sampling mu}

\item{mumax}{numeric value. The lower bound of mu when sampling mu}
}
\value{
a list \code{x} the tensor   

               \code{truthX} the tensor before adding the noise   
               
               \code{truthCs} true distribution in mode 1   
               
               \code{truthDs} true distribution in mode 2   
               
               \code{truthEs} true distribution in mode 3   
               
               \code{mus} the mean signal of all clusters   
               
               \code{binaryX} the 0-1 tensor (0:the mean signal = 0; 1:the mean signal != 0)
}
\description{
Generate a random tensor.
}
\examples{

get.data(20,20,20,2,2,2)$x
}
