% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempoCore.R
\name{tempo.runInstance}
\alias{tempo.runInstance}
\title{Build models for all pathways using the control data and test on the test population.}
\usage{
tempo.runInstance(X, Y, genesets, ctrl, test, train = NULL, comps = 10,
  validation = "CV")
}
\arguments{
\item{X}{a matrix with sample ids as row names and gene ids as column names.}

\item{Y}{a list indexed by sample ids, containing numerical values.}

\item{genesets}{a list of lists.  Outer list is indexed by gene set name, inner list contains all gene ids in a given gene set}

\item{ctrl}{a list of sample ids.  The list of control samples to use in scoring.}

\item{test}{a list of sample ids.  The list of test samples to use in scoring.}

\item{train}{a list of sample ids.  The list of control samples to train models on.  If null, train on ctrl.}

\item{comps}{maximum number of components to use in the plsr model}

\item{validation}{"CV" for 10-fold cross-validation, "LOO" for leave-one-out cross-validation. "CV" is nondeterministic and should not be used where exactly reproducible results are important}
}
\value{
a list with the following entries
\itemize{
  \item \code{ctrl} a list of the sample names used from the control set used for scoring
  \item \code{test} a list of the sample names used from the test set used for scoring
  \item \code{train} a list of the sample names used from the control set to train models
  \item \code{scores} a data frame with gene set ids as row names and a "ctrlMSE" and "score" entry for each gene set with the MSE of control age predictions in cross-validation and the calulated score, respectively
  \item \code{pred} a matrix with gene set labels, where the age prediction for sample j from the models for gene set i are at i,j
  \item \code{Y} the continuous variable of interest that models are built with respect to, e.g. age
  \item \code{genesets} the gene sets used in the analysis
}
}
\description{
Build models for all pathways using the control data and test on the test population.
}
\examples{
data("dflatExample")
data("gse32472Example")

# It is possible to run just the model-building and scoring functions and skip
# cross-validation.  This is not recommended for general use, but may be useful
# in some cases
results = tempo.runInstance(ctrl=gse32472Example$ctrl,
    test=gse32472Example$test,
    genesets=dflatExample,
    X=gse32472Example$data,
    Y=gse32472Example$age)
}
