% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempoInput.R
\name{loadGCT}
\alias{loadGCT}
\title{Load a Gene Cluster Text formatted file}
\usage{
loadGCT(target)
}
\arguments{
\item{target}{a string indicating the location of the .gct file}
}
\value{
a matrix with sample ids as row names and gene ids as column names
}
\description{
\code{loadGCT} loads a Gene Cluster Text formatted file from a text file to the data structure used by TEMPO. A .gct
file is organized as described at \href{http://www.broadinstitute.org/cancer/software/gsea/wiki/index.php/Data_formats}{the BROAD site}.
}
\examples{
# An example gene expression data set is included in the package in .gct format
exampleDataPath = file.path(path.package("tempoR"),"gse32472Example.gct")
exampleData = loadGCT(exampleDataPath)
}
