% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priorOnK_spec.R
\name{priorOnK_spec}
\alias{priorOnK_spec}
\title{Specify prior on \eqn{K}.}
\usage{
priorOnK_spec(
  P = c("fixedK", "Unif", "BNB_111", "BNB_121", "BNB_143", "BNB_443", "BNB_943",
    "Pois_1", "Pois_4", "Pois_9", "Geom_05", "Geom_02", "Geom_01", "NB_11", "NB_41",
    "NB_91"),
  K
)
}
\arguments{
\item{P}{A character indicating which specification should be
used. See Details for suitable values.}

\item{K}{A numeric or integer scalar specifying the fixed (if \code{P}
equals \code{"fixedK"}) or maximum value (if \code{P} equals \code{"Unif"}) of
\eqn{K}.}
}
\value{
A named list containing:
\itemize{
\item \code{"log_pK"}: a function of the log prior of \eqn{K}.
\item \code{"param"}: a list with the parameters.
}
}
\description{
Obtain a function to evaluate the log prior
specified for \eqn{K}.
}
\details{
The following prior specifications are supported:
\itemize{
\item \code{"fixedK"}: K has the fixed value K (second argument).
\item \code{"Unif"}: \eqn{K \sim} Unif\eqn{[1,K]}, where the upper limit is given by K (second argument).
\item \code{"BNB_111"}: \eqn{K-1 \sim} BNB(1,1,1), i.e., \eqn{K-1} follows a beta-negative binomial distribution with parameters \eqn{(1,1,1)}.
\item \code{"BNB_121"}: \eqn{K-1 \sim} BNB(1,2,1), i.e., \eqn{K-1} follows a beta-negative binomial distribution with parameters \eqn{(1,2,1)}.
\item \code{"BNB_143"}: \eqn{K-1 \sim} BNB(1,2,1), i.e., \eqn{K-1} follows a beta-negative binomial distribution with parameters \eqn{(1,4,3)}.
\item \code{"BNB_443"}: \eqn{K-1 \sim} BNB(4,4,3), i.e., \eqn{K-1} follows a beta-negative binomial distribution with parameters \eqn{(4,4,3)}.
\item \code{"BNB_943"}: \eqn{K-1 \sim} BNB(9,4,3), i.e., \eqn{K-1} follows a beta-negative binomial distribution with parameters \eqn{(9,4,3)}.
\item \code{"Pois_1"}: \eqn{K-1 \sim} pois(1), i.e., \eqn{K-1} follows a Poisson distribution with rate 1.
\item \code{"Pois_4"}: \eqn{K-1 \sim} pois(4), i.e., \eqn{K-1} follows a Poisson distribution with rate 4.
\item \code{"Pois_9"}: \eqn{K-1 \sim} pois(9), i.e., \eqn{K-1} follows a Poisson distribution with rate 9.
\item \code{"Geom_05"}: \eqn{K-1 \sim} geom(0.5), i.e., \eqn{K-1} follows a geometric distribution with success probability \eqn{p=0.5} and density \eqn{f(x)=p(1-p)^x}.
\item \code{"Geom_02"}: \eqn{K-1 \sim} geom(0.2), i.e., \eqn{K-1} follows a geometric distribution with success probability \eqn{p=0.2} and density \eqn{f(x)=p(1-p)^x}.
\item \code{"Geom_01"}: \eqn{K-1 \sim} geom(0.1), i.e., \eqn{K-1} follows a geometric distribution with success probability \eqn{p=0.1} and density \eqn{f(x)=p(1-p)^x}.
\item \code{"NB_11"}: \eqn{K-1 \sim} nbinom(1,0.5), i.e., \eqn{K-1} follows a negative-binomial distribution with \eqn{size=1} and \eqn{p=0.5}.
\item \code{"NB_41"}: \eqn{K-1 \sim} nbinom(4,0.5), i.e., \eqn{K-1} follows a negative-binomial distribution with \eqn{size=4} and \eqn{p=0.5}.
\item \code{"NB_91"}: \eqn{K-1 \sim} nbinom(9,0.5), i.e., \eqn{K-1} follows a negative-binomial distribution with \eqn{size=9} and \eqn{p=0.5}.
}
}
