% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_shmax.R
\name{superimposed_shmax}
\alias{superimposed_shmax}
\title{SHmax direction resulting from multiple plate boundaries}
\usage{
superimposed_shmax(df, PoRs, types, absolute = TRUE, PoR_weighting = NULL)
}
\arguments{
\item{df}{\code{data.frame} containing the coordinates of the point(s)
(\code{lat}, \code{lon}), and the direction of
\eqn{\sigma_{Hmax}}{SHmax} \code{azi} (in degrees)}

\item{PoRs}{multirow \code{data.frame} or \code{"euler.pole"} object that must contain \code{lat},
\code{lon} and \code{angle}}

\item{types}{character vector with length equal to number of rows in \code{PoRs}.
Type of plate boundary. Must be \code{"out"}, \code{"in"}, \code{"right"}, or
\code{"left"} for outward, inward, right-lateral, or left-lateral
moving plate boundaries, respectively.}

\item{absolute}{logical. Whether the resultant azimuth should be weighted
using the absolute rotation at the points or the angular rotation of the PoRs.}

\item{PoR_weighting}{(optional) numeric vector with length equal to number of rows in
\code{PoRs}. Extra weightings for the used PoRs.}
}
\value{
two column vector. \code{azi} is the resultant azimuth in degrees /
geographical CRS), \code{R} is the resultant length.
}
\description{
Calculates a \eqn{\sigma_{Hmax}}{SHmax} direction at given coordinates,
sourced by multiple plate boundaries. This first-order approximation is the
circular mean of the superimposed theoretical directions, weighted by the
rotation rates of the underlying PoRs.
}
\examples{
data(san_andreas)
data(nuvel1)
pors <- subset(nuvel1, plate.rot \%in\% c("eu", "na"))
res <- superimposed_shmax(san_andreas, pors, types = c("in", "right"), PoR_weighting = c(2, 1))
head(res)
}
\seealso{
\code{\link[=model_shmax]{model_shmax()}}

\code{\link[=superimposed_shmax_PB]{superimposed_shmax_PB()}} for considering distances to plate boundaries
}
