% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterStatesDF.R
\docType{class}
\name{DFFilterStates}
\alias{DFFilterStates}
\title{\code{FilterStates} subclass for data frames}
\description{
Handles filter states in a \code{data.frame}.
}
\examples{
# use non-exported function from teal.slice
include_css_files <- getFromNamespace("include_css_files", "teal.slice")
include_js_files <- getFromNamespace("include_js_files", "teal.slice")
init_filter_states <- getFromNamespace("init_filter_states", "teal.slice")

library(shiny)
library(shinyjs)

# create data frame to filter
data_df <- data.frame(
  NUM1 = 1:100,
  NUM2 = round(runif(100, min = 20, max = 23)),
  CHAR1 = sample(LETTERS[1:6], size = 100, replace = TRUE),
  CHAR2 = sample(c("M", "F"), size = 100, replace = TRUE),
  DATE = seq(as.Date("2020-01-01"), by = 1, length.out = 100),
  DATETIME = as.POSIXct(seq(as.Date("2020-01-01"), by = 1, length.out = 100))
)
data_na <- data.frame(
  NUM1 = NA,
  NUM2 = NA,
  CHAR1 = NA,
  CHAR2 = NA,
  DATE = NA,
  DATETIME = NA
)
data_df <- rbind(data_df, data_na)

# initiate `FilterStates` object
filter_states_df <- init_filter_states(
  data = data_df,
  dataname = "dataset",
  datalabel = ("label")
)

ui <- bslib::page_fluid(
  useShinyjs(),
  include_css_files(pattern = "filter-panel"),
  include_js_files(pattern = "count-bar-labels"),
  bslib::layout_column_wrap(
    width = 1 / 3,
    tags$div(
      tags$h4("Active filters"),
      filter_states_df$ui_active("fsdf")
    ),
    tags$div(
      tags$h4("Manual filter control"),
      filter_states_df$ui_add("add_filters"), tags$br(),
      tags$h4("Condition (i.e. call)"), # display the subset expression generated by FilterStates
      textOutput("call_df"), tags$br(),
      tags$h4("Formatted state"), # display human readable filter state
      textOutput("formatted_df"), tags$br()
    ),
    tags$div(
      tags$h4("Programmatic filter control"),
      actionButton("button1_df", "set NUM1 < 30", width = "100\%"), tags$br(),
      actionButton("button2_df", "set NUM2 \%in\% c(20, 21)", width = "100\%"), tags$br(),
      actionButton("button3_df", "set CHAR1 \%in\% c(\"B\", \"C\", \"D\")", width = "100\%"),
      tags$br(),
      actionButton("button4_df", "set CHAR2 == \"F\"", width = "100\%"), tags$br(),
      actionButton("button5_df", "set DATE <= 2020-02-02", width = "100\%"), tags$br(),
      actionButton("button6_df", "set DATETIME <= 2020-02-02", width = "100\%"), tags$br(),
      tags$hr(),
      actionButton("button7_df", "remove NUM1", width = "100\%"), tags$br(),
      actionButton("button8_df", "remove NUM2", width = "100\%"), tags$br(),
      actionButton("button9_df", "remove CHAR1", width = "100\%"), tags$br(),
      actionButton("button10_df", "remove CHAR2", width = "100\%"), tags$br(),
      actionButton("button11_df", "remove DATE", width = "100\%"), tags$br(),
      actionButton("button12_df", "remove DATETIME", width = "100\%"), tags$br(),
      tags$hr(),
      actionButton("button0_df", "clear all filters", width = "100\%"), tags$br()
    )
  )
)

server <- function(input, output, session) {
  filter_states_df$srv_add("add_filters")
  filter_states_df$srv_active("fsdf")

  output$call_df <- renderPrint(filter_states_df$get_call())
  output$formatted_df <- renderText(filter_states_df$format())

  observeEvent(input$button1_df, {
    filter_state <- teal_slices(teal_slice("dataset", "NUM1", selected = c(0, 30)))
    filter_states_df$set_filter_state(state = filter_state)
  })
  observeEvent(input$button2_df, {
    filter_state <- teal_slices(teal_slice("dataset", "NUM2", selected = c(20, 21)))
    filter_states_df$set_filter_state(state = filter_state)
  })
  observeEvent(input$button3_df, {
    filter_state <- teal_slices(teal_slice("dataset", "CHAR1", selected = c("B", "C", "D")))
    filter_states_df$set_filter_state(state = filter_state)
  })
  observeEvent(input$button4_df, {
    filter_state <- teal_slices(teal_slice("dataset", "CHAR2", selected = c("F")))
    filter_states_df$set_filter_state(state = filter_state)
  })
  observeEvent(input$button5_df, {
    filter_state <- teal_slices(
      teal_slice("dataset", "DATE", selected = c("2020-01-01", "2020-02-02"))
    )
    filter_states_df$set_filter_state(state = filter_state)
  })
  observeEvent(input$button6_df, {
    filter_state <- teal_slices(
      teal_slice("dataset", "DATETIME", selected = as.POSIXct(c("2020-01-01", "2020-02-02")))
    )
    filter_states_df$set_filter_state(state = filter_state)
  })

  observeEvent(input$button7_df, {
    filter_state <- teal_slices(teal_slice("dataset", "NUM1"))
    filter_states_df$remove_filter_state(filter_state)
  })
  observeEvent(input$button8_df, {
    filter_state <- teal_slices(teal_slice("dataset", "NUM2"))
    filter_states_df$remove_filter_state(filter_state)
  })
  observeEvent(input$button9_df, {
    filter_state <- teal_slices(teal_slice("dataset", "CHAR1"))
    filter_states_df$remove_filter_state(filter_state)
  })
  observeEvent(input$button10_df, {
    filter_state <- teal_slices(teal_slice("dataset", "CHAR2"))
    filter_states_df$remove_filter_state(filter_state)
  })
  observeEvent(input$button11_df, {
    filter_state <- teal_slices(
      teal_slice("dataset", "DATE")
    )
    filter_states_df$remove_filter_state(filter_state)
  })
  observeEvent(input$button12_df, {
    filter_state <- teal_slices(
      teal_slice("dataset", "DATETIME", selected = as.POSIXct(c("2020-01-01", "2020-02-02")))
    )
    filter_states_df$remove_filter_state(filter_state)
  })

  observeEvent(input$button0_df, filter_states_df$clear_filter_states())
}

if (interactive()) {
  shinyApp(ui, server)
}
}
\keyword{internal}
\section{Super class}{
\code{\link[teal.slice:FilterStates]{teal.slice::FilterStates}} -> \code{DFFilterStates}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DFFilterStates-new}{\code{DFFilterStates$new()}}
\item \href{#method-DFFilterStates-clone}{\code{DFFilterStates$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="clear_filter_states"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-clear_filter_states'><code>teal.slice::FilterStates$clear_filter_states()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="destroy"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-destroy'><code>teal.slice::FilterStates$destroy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="format"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-format'><code>teal.slice::FilterStates$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="get_call"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-get_call'><code>teal.slice::FilterStates$get_call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="get_filter_state"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-get_filter_state'><code>teal.slice::FilterStates$get_filter_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="print"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-print'><code>teal.slice::FilterStates$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="remove_filter_state"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-remove_filter_state'><code>teal.slice::FilterStates$remove_filter_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="set_filter_state"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-set_filter_state'><code>teal.slice::FilterStates$set_filter_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="srv_active"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-srv_active'><code>teal.slice::FilterStates$srv_active()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="srv_add"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-srv_add'><code>teal.slice::FilterStates$srv_add()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="ui_active"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-ui_active'><code>teal.slice::FilterStates$ui_active()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="ui_add"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-ui_add'><code>teal.slice::FilterStates$ui_add()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DFFilterStates-new"></a>}}
\if{latex}{\out{\hypertarget{method-DFFilterStates-new}{}}}
\subsection{Method \code{new()}}{
Initializes \code{DFFilterStates} object by setting \code{dataname}
and initializing \code{state_list} (\code{shiny::reactiveVal}).
This class contains a single \code{state_list} with no specified name,
which means that when calling the subset function associated with this class
(\code{dplyr::filter}), a list of conditions is passed to unnamed arguments (\code{...}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DFFilterStates$new(
  data,
  data_reactive = function(sid = "") NULL,
  dataname,
  datalabel = NULL,
  keys = character(0)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\code{data.frame})
the \code{R} object which \code{dplyr::filter} function will be applied on.}

\item{\code{data_reactive}}{(\verb{function(sid)})
should return a \code{data.frame} object or \code{NULL}.
This object is needed for the \code{FilterState} counts being updated on a change in filters.
If function returns \code{NULL} then filtered counts are not shown.
Function has to have \code{sid} argument being a character.}

\item{\code{dataname}}{(\code{character})
name of the data used in the \emph{subset expression}.
Passed to the function argument attached to this \code{FilterStates}.}

\item{\code{datalabel}}{(\code{character(1)}) optional
text label.}

\item{\code{keys}}{(\code{character})
key column names.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DFFilterStates-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DFFilterStates-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DFFilterStates$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
