% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_slices.R
\name{teal_slices-utilities}
\alias{teal_slices-utilities}
\alias{is.teal_slices}
\alias{as.teal_slices}
\alias{as.list.teal_slices}
\alias{[.teal_slices}
\alias{c.teal_slices}
\alias{format.teal_slices}
\alias{print.teal_slices}
\title{\code{teal_slices} utility functions}
\usage{
is.teal_slices(x)

as.teal_slices(x)

\method{as.list}{teal_slices}(x, recursive = FALSE, ...)

\method{[}{teal_slices}(x, i)

\method{c}{teal_slices}(...)

\method{format}{teal_slices}(x, show_all = FALSE, trim_lines = TRUE, ...)

\method{print}{teal_slices}(x, ...)
}
\arguments{
\item{x}{object to test for \code{teal_slices}, object to convert to \code{teal_slices} or a \code{teal_slices} object}

\item{recursive}{(\code{logical(1)}) flag specifying whether to also convert to list the elements of this \code{teal_slices}}

\item{...}{additional arguments passed to other functions.}

\item{i}{(\code{character} or \code{numeric} or \code{logical}) indicating which elements to extract}

\item{show_all}{(\code{logical(1)}) whether to display non-null elements of constituent \code{teal_slice} objects}

\item{trim_lines}{(\code{logical(1)}) whether to trim lines}
}
\description{
Helper functions for working with \code{\link{teal_slices}} object.
}
\examples{
filter_1 <- teal_slice(
  dataname = "dataname1",
  varname = "varname1",
  choices = letters,
  selected = "b",
  keep_na = TRUE,
  fixed = FALSE,
  extra1 = "extraone"
)
filter_2 <- teal_slice(
  dataname = "dataname1",
  varname = "varname2",
  choices = 1:10,
  keep_na = TRUE,
  selected = 2,
  fixed = TRUE,
  anchored = FALSE,
  extra2 = "extratwo"
)
filter_3 <- teal_slice(
  dataname = "dataname2",
  varname = "varname3",
  choices = 1:10 / 10,
  keep_na = TRUE,
  selected = 0.2,
  fixed = TRUE,
  anchored = FALSE,
  extra1 = "extraone",
  extra2 = "extratwo"
)

all_filters <- teal_slices(
  filter_1,
  filter_2,
  filter_3,
  exclude_varnames = list(
    "dataname1" = "varname2"
  )
)

is.teal_slices(all_filters)
all_filters[1:2]
c(all_filters[1], all_filters[2])
print(all_filters)
print(all_filters, trim_lines = FALSE)

}
\keyword{internal}
