ui = fluidPage(theme = add_theme(getShinyOption('theme')), 
               add_css(),

sidebarLayout(
  sidebarPanel(width = 3, 
  hr(),
  sliderInput("range.s", 
              label = "Range",
              min = -20, 
              max = 20, 
              value = c(-6,6)),
  hr(),
  sliderInput("mu.sev", 
              label = HTML("Mean (&mu;)"),
              min = -3, 
              max = 3, 
              step = 0.5, 
              value = 0, 
              animate = T),
  hr(),
  sliderInput("sig.sev", 
              label = HTML("Std Dev (&sigma;)"),
              min = 1, 
              max = 10, 
              step = 0.5, 
              value = 1, 
              animate = T)),

mainPanel(width = 9,
 tabsetPanel(type = 'pills',
  tabPanel('Distribution Function',
           metricsgraphicsOutput(height = "550px", "sevC")),
  tabPanel('Density',
           metricsgraphicsOutput(height = "550px", "sevP")),
  tabPanel('Survival',
           metricsgraphicsOutput(height = "550px", "sevR")),
  tabPanel('Hazard',
           metricsgraphicsOutput(height = "550px", "sevh")),
  tabPanel('Cumulative Hazard',
           metricsgraphicsOutput(height = "550px", "sevH")),
  tabPanel('Quantile',
           metricsgraphicsOutput(height = "550px", "sevQ"))))))
