% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc5.R
\name{mc5}
\alias{mc5}
\title{Perform level 5  
multiple-concentration processing}
\usage{
mc5(ae, wr = FALSE)
}
\arguments{
\item{ae}{Integer of length 1, assay endpoint id (aeid) for processing.}

\item{wr}{Logical, whether the processed data should be written to the tcpl
database}
}
\value{
A boolean of length 1, indicating the success of the processing, or 
when 'wr' is FALSE, a list where the first element is a boolean indiciating 
the success of processing and the second element is a data.table containing 
the processed data
}
\description{
\code{mc5} loads level 4 data from the tcpl 
database for the given id and performs level 5 
multiple-concentration processing. 
The processed data is then loaded into the mc5 table and 
all subsequent data is deleted with \code{\link{tcplCascade}}. See details 
for more information.

The individual processing functions are no longer exported, as it is 
typically more convenient and suggested to use the \code{\link{tcplRun}} 
wrapper function.
}
\details{
Level 5 multiple-concentration hit-calling uses the fit parameters and the 
activity cutoff methods from mc5_aeid and mc5_methods to make an activity 
call and identify the winning model for each fit.
}
\seealso{
\code{\link{Method functions}}, \code{\link{MC5_Methods}}

Other multiple-concentration data 
processing functions: \code{\link{mc1}},
  \code{\link{mc2}}, \code{\link{mc3}}, \code{\link{mc4}},
  \code{\link{mc6}}
}
