% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_biodata.R
\name{convert_biodata}
\alias{convert_biodata}
\title{Format biological data}
\usage{
convert_biodata(
  genes,
  cells,
  select = colnames(genes)[3],
  stat = "mean",
  disease = NULL,
  tissue = NULL
)
}
\arguments{
\item{genes}{data frame whose first two columns contain identifiers and the
others float values.}

\item{cells}{data frame whose first two columns contain identifiers and
the others float values.}

\item{select}{character for a column name in genes.}

\item{stat}{character for the statistic to be chosen among "mean", "median"
or "quantile".}

\item{disease}{character for the type of TCGA cancer (see the list in
extdata/disease_names.csv).}

\item{tissue}{character for the type of TCGA tissue among :
'Additional - New Primary',
'Additional Metastatic',
'Metastatic',
'Primary Blood Derived Cancer - Peripheral Blood',
'Primary Tumor',
'Recurrent Tumor',
'Solid Tissue Normal'}
}
\value{
data frame with the following columns:
\itemize{
\item \code{high} (logical): the expression levels of a selected gene,
TRUE for below or FALSE for above average.
\item \code{cells} (factor): cell types.
\item \code{value} (float): the abundance estimation of the cell types.
}
}
\description{
Merges gene and cell datasets with the same TCGA sample identifiers,
splits samples according to the expression levels of a selected gene into
two categories (below or above average) and formats into a 3-column
data frame: gene expression levels, cell types, and gene expression values.
}
\details{
\code{disease} and \code{tissue} arguments should be displayed in the title
of \code{\link[=plot.biodata]{plot.biodata()}} only if the \code{genes} argument does not already have
them in its attributes.
}
\examples{
data(tcga)
(df_formatted <- convert_biodata(tcga$genes, tcga$cells$Cibersort, "ICOS"))
}
