% Generated by roxygen2 (4.0.2): do not edit by hand
\name{vis.number.count}
\alias{vis.number.count}
\title{Plot a histogram of counts.}
\usage{
vis.number.count(.data, .ncol = 3, .name = "")
}
\arguments{
\item{.data}{Data frame with columns 'CDR3.nucleotide.sequence' and 'Read.count' or list with such data frames.}

\item{.ncol}{If .data is a list, than number of columns in a grid of histograms for each data frame in \code{.data}. Else not used.}

\item{.name}{Title for this plot.}
}
\value{
ggplot object.
}
\description{
Plot a histogram of distribution of counts of CDR3 nucleotide sequences. On y-axis are number of counts.
}
\details{
If \code{.data} is a data frame, than one histogram will be plotted. Is \code{.data} is a list, than grid of histograms
will be plotted.
}
\examples{
\dontrun{
load('immdata.rda')
# Plot one histogram with main title.
vis.number.count(immdata[[1]], 'Main title here')
# Plot a grid of histograms with 2 columns.
vis.number.count(immdata, 2)
}
}

