% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stacked_table.R
\name{stack_table}
\alias{stack_table}
\alias{Stacked_table}
\alias{stacked_table}
\alias{stack_table_list}
\title{Stack tables}
\usage{
stack_table(..., spacing = 2L, meta = NULL)

stack_table_list(tables, spacing = 2L, meta = NULL)
}
\arguments{
\item{...}{\code{stack_table()} only: Any number other \link{Tatoo_table}, or anything
that can be coerced to a data.frame.}

\item{spacing}{Number of lineskips between the tables when exporting to
xlsx}

\item{meta}{a \code{\link{tt_meta}} object (optional)}

\item{tables}{\code{stack_table_list()} only: Same as \code{(...)} for \code{stack_table},
just that a list can be supplied instead of individual arguments.}
}
\value{
a Stacked_table: a list of Tatoo_tables with additional
\code{spacing} attribute that controls the default spacing between the tables
when it is exported.
}
\description{
Stack tables on top of each other. This can be used to print several tables
on one Excel sheet with \code{\link[=as_workbook]{as_workbook()}} or \code{\link[=save_xlsx]{save_xlsx()}}.
}
\examples{

df1 <- iris[1:5, 3:5]
df2 <- iris[100:105, 3:5]

stack_table(df1, df2)

# ```````````````````````````````````````````
# `      Petal.Length Petal.Width Species
# `   1:          1.4         0.2  setosa
# `   2:          1.4         0.2  setosa
# `   3:          1.3         0.2  setosa
# `   4:          1.5         0.2  setosa
# `   5:          1.4         0.2  setosa
# `   ______________________________________
# `      Petal.Length Petal.Width    Species
# `   1:          4.1         1.3 versicolor
# `   2:          6.0         2.5  virginica
# `   3:          5.1         1.9  virginica
# `   4:          5.9         2.1  virginica
# `   5:          5.6         1.8  virginica
# `   6:          5.8         2.2  virginica
# `
# ```````````````````````````````````````````

}
\seealso{
Attribute setter: \link{spacing<-}

Other Tatoo tables: \code{\link{comp_table}},
  \code{\link{mash_table}}, \code{\link{tag_table}},
  \code{\link{tatoo_table}}
}
