% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mashed_table.R
\name{mash_table}
\alias{mash_table}
\alias{Mashed_table}
\alias{mashed_table}
\alias{mash_table_list}
\title{Mash Tables}
\usage{
mash_table(..., mash_method = "row", id_vars = NULL,
  insert_blank_row = FALSE, sep_height = 24, meta = NULL,
  rem_ext = NULL)

mash_table_list(tables, mash_method = "row", id_vars = NULL,
  insert_blank_row = FALSE, sep_height = 24, meta = NULL,
  rem_ext = NULL)
}
\arguments{
\item{...}{\code{mash_table()} only: \code{data.frame}s with the same row and column
count. Elements of \code{(...)} can be named, but the name must differ from
the argument names of this function.}

\item{mash_method}{either \code{"row"} or \code{"col"}. should the tables be mashed by
row or by column?}

\item{id_vars}{Only if mashing columns: one ore more colnames of the tables
to be mashed. If supplied, columns of both input tables are combined with
\code{\link[=merge]{merge()}}, otherwise \code{\link[=cbind]{cbind()}} is used.}

\item{insert_blank_row}{Only if mashing rows: logical. Whether to insert
blank rows between mash-groups. \emph{Warning: this converts all columns to
character.} Use with care.}

\item{sep_height}{Only has an effect when exporting to \code{xlsx}. if
\code{insert_blank_row == TRUE}, hight of the inserted row, else height of the
top row of each mash-group.}

\item{meta}{A  \link{TT_meta} object. if supplied, output will also be a
\link{Tagged_table}.}

\item{rem_ext}{\code{character}. For \code{mash_table} to work, the column names of all
elements of \code{dat} must be identical. Sometimes you will have the situation
that column names are identical except for a suffix, such as \code{length} and
\code{lenght.sd}. The \code{rem_ext} option can be used to remove such suffixes.}

\item{tables}{\code{mash_table_list()} only: a \code{list} of \code{data.frame}s as
described for \code{(...)}}
}
\value{
a \code{Mashed_table}: a \code{list} of \code{data.table}s with additional
\code{mash_method}, \code{insert_blank_row} and \code{sep_height} attributes, that
influence how the table looks when it is printed or exported.
}
\description{
Mash tables are designed to make it easy to put together multidimensional
tables from two data.frames. An example where this might be useful is if you
have a data.frame of numeric values, and a second data.frame of associated
standard errors.
}
\details{
Mash table provides a framework to mash those two data.frames together into
one data.frame with alternating rows or columns.
}
\examples{

df_mean <- data.frame(
  Species = c("setosa", "versicolor", "virginica"),
  length = c(5.01, 5.94, 6.59),
  width = c(3.43, 2.77, 2.97)
)

df_sd <- data.frame(
  Species = c("setosa", "versicolor", "virginica"),
  length = c(0.35, 0.52, 0.64),
  width = c(0.38, 0.31, 0.32)
)


# Mash by row

mash_table(df_mean, df_sd)

#       Species length width
# 1:     setosa   5.01  3.43
# 2:     setosa   0.35  0.38
# 3: versicolor   5.94  2.77
# 4: versicolor   0.52  0.31
# 5:  virginica   6.59  2.97
# 6:  virginica   0.64  0.32


# Mash by column

mash_table(
  df_mean, df_sd,
  mash_method = 'col',
  id_vars = 'Species'
)

#       Species    Species length length width width
# 1:     setosa     setosa   5.01   0.35  3.43  0.38
# 2: versicolor versicolor   5.94   0.52  2.77  0.31
# 3:  virginica  virginica   6.59   0.64  2.97  0.32


# Use the id_vars argument to prevent undesired dpulicated columns,
# and name the input data.frames to get multi-col headings.

mash_table(
  mean = df_mean, sd = df_sd,
  mash_method = 'col',
  id_vars = 'Species'
)

#    ..........     ..length...     ...width...
# 1    Species     mean     sd     mean     sd
# 2     setosa     5.01   0.35     3.43   0.38
# 3 versicolor     5.94   0.52     2.77   0.31
# 4  virginica     6.59   0.64     2.97   0.32

}
\seealso{
Attribute setters: \link{mash_method<-}

Other Tatoo tables: \code{\link{comp_table}},
  \code{\link{stack_table}}, \code{\link{tag_table}},
  \code{\link{tatoo_table}}
}
