% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_target.R, R/tar_target_raw.R
\name{tar_target}
\alias{tar_target}
\alias{tar_target_raw}
\title{Declare a target.}
\usage{
tar_target(
  name,
  command,
  pattern = NULL,
  tidy_eval = targets::tar_option_get("tidy_eval"),
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  format = targets::tar_option_get("format"),
  repository = targets::tar_option_get("repository"),
  iteration = targets::tar_option_get("iteration"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = isTRUE(targets::tar_option_get("garbage_collection")),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  storage = targets::tar_option_get("storage"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  description = targets::tar_option_get("description")
)

tar_target_raw(
  name,
  command,
  pattern = NULL,
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  deps = NULL,
  string = NULL,
  format = targets::tar_option_get("format"),
  repository = targets::tar_option_get("repository"),
  iteration = targets::tar_option_get("iteration"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = isTRUE(targets::tar_option_get("garbage_collection")),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  storage = targets::tar_option_get("storage"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  description = targets::tar_option_get("description")
)
}
\arguments{
\item{name}{Symbol, name of the target.
In \code{\link[=tar_target]{tar_target()}}, \code{name} is an unevaluated symbol, e.g.
\code{tar_target(name = data)}.
In \code{\link[=tar_target_raw]{tar_target_raw()}}, \code{name} is a character string, e.g.
\code{tar_target_raw(name = "data")}.

A target name must be a valid name for a symbol in R, and it
must not start with a dot. Subsequent targets
can refer to this name symbolically to induce a dependency relationship:
e.g. \code{tar_target(downstream_target, f(upstream_target))} is a
target named \code{downstream_target} which depends on a target
\code{upstream_target} and a function \code{f()}.

In most cases, The target name is the name of its local data file
in storage. Some file systems are not case sensitive, which means
converting a name to a different case may overwrite a different target.
Please ensure all target names have unique names when converted to
lower case.

In addition, a target's
name determines its random number generator seed. In this way,
each target runs with a reproducible seed so someone else
running the same pipeline should get the same results,
and no two targets in the same pipeline share the same seed.
(Even dynamic branches have different names and thus different seeds.)
You can recover the seed of a completed target
with \code{tar_meta(your_target, seed)} and run \code{\link[=tar_seed_set]{tar_seed_set()}}
on the result to locally recreate the target's initial RNG state.}

\item{command}{R code to run the target.
In \code{\link[=tar_target]{tar_target()}}, \code{command} is an unevaluated expression, e.g.
\code{tar_target(command = data)}.
In \code{\link[=tar_target_raw]{tar_target_raw()}}, \code{command} is an evaluated expression, e.g.
\code{tar_target_raw(command = quote(data))}.}

\item{pattern}{Code to define a dynamic branching branching for a target.
In \code{\link[=tar_target]{tar_target()}}, \code{pattern} is an unevaluated expression, e.g.
\code{tar_target(pattern = map(data))}.
In \code{\link[=tar_target_raw]{tar_target_raw()}}, \code{command} is an evaluated expression, e.g.
\code{tar_target_raw(pattern = quote(map(data)))}.

To demonstrate dynamic branching patterns, suppose we have
a pipeline with numeric vector targets \code{x} and \code{y}. Then,
\code{tar_target(z, x + y, pattern = map(x, y))} implicitly defines
branches of \code{z} that each compute \code{x[1] + y[1]}, \code{x[2] + y[2]},
and so on. See the user manual for details.}

\item{tidy_eval}{Logical, whether to enable tidy evaluation
when interpreting \code{command} and \code{pattern}. If \code{TRUE}, you can use the
"bang-bang" operator \verb{!!} to programmatically insert
the values of global objects.}

\item{packages}{Character vector of packages to load right before
the target runs or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{format}{Optional storage format for the target's return value.
With the exception of \code{format = "file"}, each target
gets a file in \verb{_targets/objects}, and each format is a different
way to save and load this file. See the "Storage formats" section
for a detailed list of possible data storage formats.}

\item{repository}{Character of length 1, remote repository for target
storage. Choices:
\itemize{
\item \code{"local"}: file system of the local machine.
\item \code{"aws"}: Amazon Web Services (AWS) S3 bucket. Can be configured
with a non-AWS S3 bucket using the \code{endpoint} argument of
\code{\link[=tar_resources_aws]{tar_resources_aws()}}, but versioning capabilities may be lost
in doing so.
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
\item \code{"gcp"}: Google Cloud Platform storage bucket.
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
\item A character string from \code{\link[=tar_repository_cas]{tar_repository_cas()}} for content-addressable
storage.
}

Note: if \code{repository} is not \code{"local"} and \code{format} is \code{"file"}
then the target should create a single output file.
That output file is uploaded to the cloud and tracked for changes
where it exists in the cloud. As of \code{targets} version 1.11.0 and higher,
the local file is no longer deleted after the target runs.}

\item{iteration}{Character of length 1, name of the iteration mode
of the target. Choices:
\itemize{
\item \code{"vector"}: branching happens with \code{vctrs::vec_slice()} and
aggregation happens with \code{vctrs::vec_c()}.
\item \code{"list"}, branching happens with \verb{[[]]} and aggregation happens with
\code{list()}.
\item \code{"group"}: \code{dplyr::group_by()}-like functionality to branch over
subsets of a non-dynamic data frame.
For \code{iteration = "group"}, the target must not by dynamic
(the \code{pattern} argument of \code{\link[=tar_target]{tar_target()}} must be left \code{NULL}).
The target's return value must be a data
frame with a special \code{tar_group} column of consecutive integers
from 1 through the number of groups. Each integer designates a group,
and a branch is created for each collection of rows in a group.
See the \code{\link[=tar_group]{tar_group()}} function to see how you can
create the special \code{tar_group} column with \code{dplyr::group_by()}.
}}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline. In addition,
as of \code{targets} version 1.8.0.9011, a value of \code{NULL} is given
to upstream dependencies with \code{error = "null"} if loading fails.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
\item \code{"trim"}: all currently running targets stay running. A queued
target is allowed to start if:
\enumerate{
\item It is not downstream of the error, and
\item It is not a sibling branch from the same \code{\link[=tar_target]{tar_target()}} call
(if the error happened in a dynamic branch).
}

The idea is to avoid starting any new work that the immediate error
impacts. \code{error = "trim"} is just like \code{error = "abridge"},
but it allows potentially healthy regions of the dependency graph
to begin running.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
}}

\item{memory}{Character of length 1, memory strategy. Possible values:
\itemize{
\item \code{"auto"} (default): equivalent to \code{memory = "transient"} in almost
all cases. But to avoid superfluous reads from disk,
\code{memory = "auto"} is equivalent to \code{memory = "persistent"} for
for non-dynamically-branched targets that other targets
dynamically branch over. For example: if your pipeline has
\code{tar_target(name = y, command = x, pattern = map(x))},
then \code{tar_target(name = x, command = f(), memory = "auto")}
will use persistent memory in order to avoid rereading all of \code{x}
for every branch of \code{y}.
\item \code{"transient"}: the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
\item \code{"persistent"}: the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
}

For cloud-based file targets
(e.g. \code{format = "file"} with \code{repository = "aws"}),
the \code{memory} option applies to the
temporary local copy of the file:
\code{"persistent"} means it remains until the end of the pipeline
and is then deleted,
and \code{"transient"} means it gets deleted as soon as possible.
The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical: \code{TRUE} to run \code{base::gc()}
just before the target runs, in whatever R process it is about to run
(which could be a parallel worker).
\code{FALSE} to omit garbage collection.
Numeric values get converted to \code{FALSE}.
The \code{garbage_collection} option in \code{\link[=tar_option_set]{tar_option_set()}}
is independent of the
argument of the same name in \code{\link[=tar_target]{tar_target()}}.}

\item{deployment}{Character of length 1. If \code{deployment} is
\code{"main"}, then the target will run on the central controlling R process.
Otherwise, if \code{deployment} is \code{"worker"} and you set up the pipeline
with distributed/parallel computing, then
the target runs on a parallel worker. For more on distributed/parallel
computing in \code{targets}, please visit
\url{https://books.ropensci.org/targets/crew.html}.}

\item{priority}{Deprecated on 2025-04-08 (\code{targets} version 1.10.1.9013).
\code{targets} has moved to a more efficient scheduling algorithm
(\url{https://github.com/ropensci/targets/issues/1458})
which cannot support priorities.
The \code{priority} argument of \code{\link[=tar_target]{tar_target()}} no longer has a reliable
effect on execution order.}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{storage}{Character string to control when the output of the target
is saved to storage. Only relevant when using \code{targets}
with parallel workers (\url{https://books.ropensci.org/targets/crew.html}).
Must be one of the following values:
\itemize{
\item \code{"worker"} (default): the worker saves/uploads the value.
\item \code{"main"}: the target's return value is sent back to the
host machine and saved/uploaded locally.
\item \code{"none"}: \code{targets} makes no attempt to save the result
of the target to storage in the location where \code{targets}
expects it to be. Saving to storage is the responsibility
of the user. Use with caution.
}}

\item{retrieval}{Character string to control when the current target
loads its dependencies into memory before running.
(Here, a "dependency" is another target upstream that the current one
depends on.) Only relevant when using \code{targets}
with parallel workers (\url{https://books.ropensci.org/targets/crew.html}).
Must be one of the following values:
\itemize{
\item \code{"auto"} (default): equivalent to \code{retrieval = "worker"} in almost all
cases. But to avoid unnecessary reads from disk, \code{retrieval = "auto"}
is equivalent to \code{retrieval = "main"} for dynamic branches that
branch over non-dynamic targets. For example: if your pipeline has
\code{tar_target(x, command = f())}, then
\code{tar_target(y, command = x, pattern = map(x), retrieval = "auto")}
will use \code{"main"} retrieval in order to avoid rereading all of \code{x}
for every branch of \code{y}.
\item \code{"worker"}: the worker loads the target's dependencies.
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target runs.
\item \code{"none"}: \code{targets} makes no attempt to load its
dependencies. With \code{retrieval = "none"}, loading dependencies
is the responsibility of the user. Use with caution.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}

\item{description}{Character of length 1, a custom free-form human-readable
text description of the target. Descriptions appear as target labels
in functions like \code{\link[=tar_manifest]{tar_manifest()}} and \code{\link[=tar_visnetwork]{tar_visnetwork()}},
and they let you select subsets of targets for the \code{names} argument of
functions like \code{\link[=tar_make]{tar_make()}}. For example,
\code{tar_manifest(names = tar_described_as(starts_with("survival model")))}
lists all the targets whose descriptions start with the character
string \code{"survival model"}.}

\item{deps}{Optional character vector of the adjacent upstream
dependencies of the target, including targets and global objects.
If \code{NULL}, dependencies are resolved automatically as usual.
The \code{deps} argument is only for developers of extension
packages such as \code{tarchetypes},
not for end users, and it should almost never be used at all.
In scenarios that at first appear to requires \code{deps},
there is almost always a simpler and more robust workaround
that avoids setting \code{deps}.}

\item{string}{Optional string representation of the command.
Internally, the string gets hashed to check if the command changed
since last run, which helps \code{targets} decide whether the
target is up to date. External interfaces can take control of
\code{string} to ignore changes in certain parts of the command.
If \code{NULL}, the strings is just deparsed from \code{command} (default).}
}
\value{
A target object. Users should not modify these directly,
just feed them to \code{\link[=list]{list()}} in your target script file
(default: \verb{_targets.R}).
}
\description{
A target is a single step of computation in a pipeline.
It runs an R command and returns a value.
This value gets treated as an R object that can be used
by the commands of targets downstream. Targets that
are already up to date are skipped. See the user manual
for more details.

\code{\link[=tar_target]{tar_target()}} defines a target using non-standard evaluation.
The \code{name} argument is an unevaluated symbol,
and the \code{command} and \code{pattern}
arguments are unevaluated expressions. Example:
\code{tar_target(name = data, command = get_data())}.

\code{\link[=tar_target_raw]{tar_target_raw()}} defines a target with standard evaluation.
The \code{name} argument is a character string,
and the \code{command} and \code{pattern}
arguments are evaluated expressions. Example:
\code{tar_target_raw(name = "data", command = quote(get_data()))}.
\code{\link[=tar_target_raw]{tar_target_raw()}} also has extra arguments \code{deps} and \code{string}
for advanced customization.
}
\section{Target objects}{

Functions like \code{tar_target()} produce target objects,
special objects with specialized sets of S3 classes.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\section{Storage formats}{

\code{targets} has several built-in storage formats to control how return
values are saved and loaded from disk:
\itemize{
\item \code{"rds"}: Default, uses \code{saveRDS()} and \code{readRDS()}. Should work for
most objects, but slow.
\item \code{"auto"}: either \code{"file"} or \code{"qs"}, depending on the return value
of the target. If the return value is a character vector of
existing files (and/or directories), then the format becomes
\code{"file"} before \code{\link[=tar_make]{tar_make()}} saves the target. Otherwise,
the format becomes \code{"qs"}.

NOTE: \code{format = "auto"} slows down pipelines with 10000+ targets
because it creates deep copies of 20000+ internal data objects.
Pipelines of this size should use a more explicit format instead of
\code{"auto"}.
\item \code{"qs"}: Uses \code{qs2::qs_save()} and \code{qs2::qs_read()}. Should work for
most objects, much faster than \code{"rds"}. Optionally configure settings
through \code{tar_resources()} and \code{tar_resources_qs()}.

Prior to \code{targets} version 1.8.0.9014, \code{format = "qs"} used the \code{qs}
package. \code{qs} has since been superseded in favor of \code{qs2}, and so
later versions of \code{targets} use \code{qs2} to save new data. To read
existing data, \code{targets} first attempts \code{\link[qs2:qs_read]{qs2::qs_read()}}, and then if
that fails, it falls back on \code{\link[qs:qread]{qs::qread()}}.
\item \code{"feather"}: Uses \code{arrow::write_feather()} and
\code{arrow::read_feather()} (version 2.0). Much faster than \code{"rds"},
but the value must be a data frame. Optionally set
\code{compression} and \code{compression_level} in \code{arrow::write_feather()}
through \code{tar_resources()} and \code{tar_resources_feather()}.
Requires the \code{arrow} package (not installed by default).
\item \code{"parquet"}: Uses \code{arrow::write_parquet()} and
\code{arrow::read_parquet()} (version 2.0). Much faster than \code{"rds"},
but the value must be a data frame. Optionally set
\code{compression} and \code{compression_level} in \code{arrow::write_parquet()}
through \code{tar_resources()} and \code{tar_resources_parquet()}.
Requires the \code{arrow} package (not installed by default).
\item \code{"fst"}: Uses \code{fst::write_fst()} and \code{fst::read_fst()}.
Much faster than \code{"rds"}, but the value must be
a data frame. Optionally set the compression level for
\code{fst::write_fst()} through \code{tar_resources()} and \code{tar_resources_fst()}.
Requires the \code{fst} package (not installed by default).
\item \code{"fst_dt"}: Same as \code{"fst"}, but the value is a \code{data.table}.
Deep copies are made as appropriate in order to protect
against the global effects of in-place modification.
Optionally set the compression level the same way as for \code{"fst"}.
\item \code{"fst_tbl"}: Same as \code{"fst"}, but the value is a \code{tibble}.
Optionally set the compression level the same way as for \code{"fst"}.
\item \code{"keras"}: superseded by \code{\link[=tar_format]{tar_format()}} and incompatible
with \code{error = "null"} (in \code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}}).
Uses \code{keras::save_model_hdf5()} and
\code{keras::load_model_hdf5()}. The value must be a Keras model.
Requires the \code{keras} package (not installed by default).
\item \code{"torch"}: superseded by \code{\link[=tar_format]{tar_format()}} and incompatible
with \code{error = "null"} (in \code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}}).
Uses \code{torch::torch_save()} and \code{torch::torch_load()}.
The value must be an object from the \code{torch} package
such as a tensor or neural network module.
Requires the \code{torch} package (not installed by default).
\item \code{"file"}: A file target. To use this format,
the target needs to manually identify or save some data
and return a character vector of paths
to the data (must be a single file path if \code{repository}
is not \code{"local"}). (These paths must be existing files
and nonempty directories.)
Then, \code{targets} automatically checks those files and cues
the appropriate run/skip decisions if those files are out of date.
Those paths must point to files or directories,
and they must not contain characters \code{|} or \code{*}.
All the files and directories you return must actually exist,
or else \code{targets} will throw an error. (And if \code{storage} is \code{"worker"},
\code{targets} will first stall out trying to wait for the file
to arrive over a network file system.)
If the target does not create any files, the return value should be
\code{character(0)}.

If \code{repository} is not \code{"local"} and \code{format} is \code{"file"},
then the character vector returned by the target must be of length 1
and point to a single file. (Directories and vectors of multiple
file paths are not supported for file targets on the cloud.)
That output file is uploaded to the cloud and tracked for changes
where it exists in the cloud. As of \code{targets} version >= 1.11.0,
the physical file is retained locally after the target runs.
(Previous versions of \code{targets} deleted the file locally.)
\item \code{"url"}: An input URL. For this storage format,
\code{repository} is implicitly \code{"local"},
URL format is like \code{format = "file"}
except the return value of the target is a URL that already exists
and serves as input data for downstream targets. Optionally
supply a custom \code{curl} handle through
\code{tar_resources()} and \code{tar_resources_url()}.
in \code{new_handle()}, \code{nobody = TRUE} is important because it
ensures \code{targets} just downloads the metadata instead of
the entire data file when it checks time stamps and hashes.
The data file at the URL needs to have an ETag or a Last-Modified
time stamp, or else the target will throw an error because
it cannot track the data. Also, use extreme caution when
trying to use \code{format = "url"} to track uploads. You must be absolutely
certain the ETag and Last-Modified time stamp are fully updated
and available by the time the target's command finishes running.
\code{targets} makes no attempt to wait for the web server.
\item A custom format can be supplied with \code{tar_format()}. For this choice,
it is the user's responsibility to provide methods for (un)serialization
and (un)marshaling the return value of the target.
\item The formats starting with \code{"aws_"} are deprecated as of 2022-03-13
(\code{targets} version > 0.10.0). For cloud storage integration, use the
\code{repository} argument instead.
}

Formats \code{"rds"}, \code{"file"}, and \code{"url"} are general-purpose formats
that belong in the \code{targets} package itself.
Going forward, any additional formats should be implemented with
\code{\link[=tar_format]{tar_format()}} in third-party packages like \code{tarchetypes}
and \code{geotargets} (for example: \code{tarchetypes::tar_format_nanoparquet()}).
Formats \code{"qs"}, \code{"fst"}, etc. are legacy formats from before the
existence of \code{\link[=tar_format]{tar_format()}}, and they will continue to remain in
\code{targets} without deprecation.
}

\examples{
# Defining targets does not run them.
data <- tar_target(target_name, get_data(), packages = "tidyverse")
analysis <- tar_target(analysis, analyze(x), pattern = map(x))
# In a pipeline:
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  library(targets)
  library(tarchetypes)
  list(
    tar_target(name = x, command = 1 + 1),
    tar_target_raw(name = "y", command = quote(x + y))
  )
})
tar_make()
tar_read(x)
})
# Tidy evaluation
tar_option_set(envir = environment())
n_rows <- 30L
data <- tar_target(target_name, get_data(!!n_rows))
print(data)
# Disable tidy evaluation:
data <- tar_target(target_name, get_data(!!n_rows), tidy_eval = FALSE)
print(data)
tar_option_reset()
}
}
\seealso{
Other targets: 
\code{\link{tar_cue}()}
}
\concept{targets}
