% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_hook_inner.R
\name{tar_hook_inner}
\alias{tar_hook_inner}
\title{Hook to wrap dependencies}
\usage{
tar_hook_inner(targets, hook, names = NULL, names_wrap = NULL)
}
\arguments{
\item{targets}{A list of target objects. The input target list
can be arbitrarily nested, but it must consist entirely of target
objects. In addition, the return value is a simple list
where each element is a target object.
All hook functions remove the nested structure of the input target list.}

\item{hook}{R code to wrap each target's command.
The hook must contain the special placeholder symbol \code{.x}
so \code{tar_hook_inner()} knows where to insert the code to wrap
mentions of dependencies.
The hook code is quoted (not evaluated) so there is no need
to wrap it in \code{quote()}, \code{expression()}, or similar.}

\item{names}{Name of targets in the target list
to apply the hook. You can supply symbols, a character vector,
or tidyselect helpers like \code{\link[=starts_with]{starts_with()}}.
Targets not included in \code{names} still remain in the target list,
but they are not modified because the hook does not apply to them.}

\item{names_wrap}{Names of targets to wrap with the hook
where they appear as dependencies in the commands of other targets.
You can supply symbols, a character vector,
or tidyselect helpers like \code{\link[=starts_with]{starts_with()}}.}
}
\value{
A flattened list of target objects with the hooks applied.
Even if the input target list had a nested structure,
the return value is a simple list where each element is a target object.
All hook functions remove the nested structure of the input target list.
}
\description{
In the command of each target, wrap each mention of
each dependency target in an arbitrary R expression.
}
\details{
The expression you supply to \code{hook}
must contain the special placeholder symbol \code{.x}
so \code{tar_hook_inner()} knows where to insert the original command
of the target.
}
\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
targets::tar_script({
  targets <- list(
    # Nested target lists work with hooks.
    list(
      targets::tar_target(x1, task1()),
      targets::tar_target(x2, task2(x1))
    ),
    targets::tar_target(x3, task3(x2, x1)),
    targets::tar_target(y1, task4(x3))
  )
  tarchetypes::tar_hook_inner(
    targets = targets,
    hook = fun(.x),
    names = starts_with("x")
  )
})
targets::tar_manifest(fields = command)
})
}
}
\seealso{
Other hooks: 
\code{\link{tar_hook_before}()},
\code{\link{tar_hook_outer}()}
}
\concept{hooks}
