% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xyplot.acf.R
\name{xyplot.acf}
\alias{xyplot.acf}
\title{Plot Autocovariance and Autocorrelation Functions}
\usage{
\method{xyplot}{acf}(x, data = NULL, ci = 0.95, ci_type = c("white",
  "ma"), ci_col = trellis.par.get("add.line")$col, ci_lty = 2, ...)
}
\arguments{
\item{x}{An 'acf' object.}

\item{data}{Ignored}

\item{ci}{Confidence level.}

\item{ci_type}{Type of confidence level.}

\item{ci_col}{Line color for the confidence levels.}

\item{ci_lty}{Line type for the confidence levels.}

\item{...}{Arguments passed on to \code{\link[lattice:xyplot]{lattice::xyplot()}}.}
}
\value{
Returns and plots a \code{trellis} object.
}
\description{
This is a version of \code{\link[stats:plot.acf]{stats::plot.acf()}}.
}
\examples{
z <- ts(matrix(rnorm(400), 100, 4), start = c(1961, 1), frequency = 12)
xyplot(acf(z))
}
\seealso{
\code{\link[lattice:xyplot]{lattice::xyplot()}}, \code{\link[stats:plot.acf]{stats::plot.acf()}}, \code{\link[stats:acf]{stats::acf()}}.
}
\author{
Original by Brian Ripley.
}
