% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/matrigraph.R
\docType{methods}
\name{matrigraph}
\alias{matrigraph}
\alias{matrigraph-method}
\alias{pvi}
\alias{pvi-method}
\alias{pvi,matrix-method}
\alias{pvi,data.frame-method}
\alias{matrigraph,matrix-method}
\alias{matrigraph,data.frame-method}
\title{Matrigraph}
\usage{
matrigraph(object, ...)

pvi(object, ...)

\S4method{pvi}{matrix}(object)

\S4method{pvi}{data.frame}(object)

\S4method{matrigraph}{matrix}(object, reverse = FALSE, axes = TRUE, ...)

\S4method{matrigraph}{data.frame}(object, reverse = FALSE, ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table).}

\item{...}{Currently not used.}

\item{reverse}{A \code{\link{logical}} scalar: should negative deviations be centered
(see details)?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot? It will
omit labels where they would abut or overlap previously drawn labels.}
}
\value{
\itemize{
\item \code{matrigraph()} is called for its side-effects: it results in a graphic
being displayed (invisibly returns \code{object}).
\item \code{pvi()} returns a \code{\link{numeric}} \code{\link{matrix}}.
}
}
\description{
\itemize{
\item \code{matrigraph()} produces a heatmap highlighting the deviations from
independence.
\item \code{pvi()} computes for each cell of a numeric matrix the percentage to the
column theoretical independence value.
}
}
\details{
PVI (in french "pourcentages de valeur d'indépendance") is calculated for
each cell as the percentage to the column theoretical independence value:
PVI greater than \eqn{1} represent positive deviations from the
independence, whereas PVI smaller than \eqn{1} represent negative
deviations (Desachy 2004).

The PVI matrix allows to explore deviations from independence (an
intuitive approach to \eqn{\chi^2}{Chi-squared}), in such a way that a
high-contrast matrix has quite significant deviations,
with a low risk of being due to randomness (Desachy 2004).

\code{matrigraph()} displays the deviations from independence:
\itemize{
\item If the PVI is equal to \eqn{1} (statistical independence), the cell of the
matrix is filled in grey.
\item If the PVI is less than \eqn{1} (negative deviation from independence),
the size of the grey square is proportional to the PVI (the white margin
thus represents the fraction of negative deviation).
\item If the PVI is greater than \eqn{1} (positive deviation), a black
square representing the fraction of positive deviations is
superimposed. For large positive deviations (PVI greater than \eqn{2}),
the cell in filled in black.
}

If \code{reverse} is \code{TRUE}, the fraction of negative deviations is displayed
as a white square.
}
\examples{
## Data from Desachy 2004
data("compiegne", package = "folio")

## Matrigraph
matrigraph(compiegne)
matrigraph(compiegne, reverse = TRUE)

## Compute PVI
counts_pvi <- pvi(compiegne)
plot_heatmap(counts_pvi, col = khroma::color("iridescent")(12))
}
\references{
Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
graphique pour tableaux de comptages. \emph{Revue archéologique de Picardie},
3(1), 39-56. \doi{10.3406/pica.2004.2396}.
}
\seealso{
\code{\link[=plot_heatmap]{plot_heatmap()}}

Other plot methods: 
\code{\link{plot_bertin}()},
\code{\link{plot_diceleraas}()},
\code{\link{plot_ford}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_rank}()},
\code{\link{plot_spot}()},
\code{\link{seriograph}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
