% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.R
\name{valid-notes}
\alias{valid-notes}
\alias{is_note}
\alias{is_chord}
\alias{noteworthy}
\alias{as_noteworthy}
\alias{is_noteworthy}
\title{Check note and chord validity}
\usage{
is_note(x, na.rm = FALSE)

is_chord(x, na.rm = FALSE)

noteworthy(x, na.rm = FALSE)

as_noteworthy(x, octaves = NULL, accidentals = NULL, format = NULL)

is_noteworthy(x)
}
\arguments{
\item{x}{character, a noteworthy string.}

\item{na.rm}{remove \code{NA}s.}

\item{octaves}{\code{NULL} or character, \code{"tick"} or \code{"integer"} octave numbering
in result.}

\item{accidentals}{\code{NULL} or character, represent accidentals, \code{"flat"} or
\code{"sharp"}.}

\item{format}{\code{NULL} or character, the timestep delimiter format, \code{"space"}
or \code{"vector"}.}
}
\value{
depends on the function
}
\description{
Check if a string is comprised exclusively of valid note and/or chord syntax.
}
\details{
\code{is_note()} and \code{is_chord()} are vectorized and their positive results
are mutually exclusive. \code{noteworthy()} is also vectorized and performs both
checks, but it returns a scalar logical result indicating whether the entire
set contains exclusively valid entries.

\code{as_noteworthy()} can be used to coerce to the \code{noteworthy} class. Coercion
will fail if the string is not noteworthy.
While many functions will work on simple character strings and, if their
syntax is valid, coerce them to the 'noteworthy' class, it is recommended to
use this class. Not all functions are so aggressive, and several generic
methods are implemented for the class. It also offers its own \code{print()}
and \code{summary()} methods for noteworthy strings.
An added benefit to using \code{as_noteworthy()} is to conform all notes in a
noteworthy string to specific formatting for accidentals and octave numbering.
Functions that output a noteworthy string attach the \code{noteworthy} class.

When \code{octaves}, \code{accidentals}, and \code{format} are \code{NULL}, formatting is
inferred from the noteworthy string input. When mixed formats are present,
tick format is the default for octave numbering and flats are the default for
accidentals.
}
\examples{
x <- "a# b_ c, d'' e3 g_4 A m c2e_2g2 cegh" # includes invalid syntax
data.frame(
  x = strsplit(x, " ")[[1]],
  note = is_note(x),
  chord = is_chord(x),
  either = noteworthy(x))

is_diatonic("ace ac#e d e_", "c")

x <- "a# b_ c,~ c, d'' e3 g_4 c2e_2g2"
noteworthy(x) # is it noteworthy; a validity check for any string
x <- as_noteworthy(x) # coerce to 'noteworthy' class, conform formatting
is_noteworthy(x) # check for 'noteworthy' class
x

summary(x)

x <- as_noteworthy(x, format = "vector", octaves = "integer",
                   accidentals = "flat")
x

summary(x)
}
\seealso{
\code{\link[=note-checks]{note-checks()}}, \code{\link[=note-metadata]{note-metadata()}}, \code{\link[=note-summaries]{note-summaries()}},
\code{\link[=note-coerce]{note-coerce()}}
}
